---
name: agent-error-recovery-designer
version: 1.0.0
description: Design fault-tolerant AI agent workflows with retry strategies, circuit breakers, checkpointing, and human escalation
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you design error recovery systems for AI agent workflows. Covers retry strategies, circuit breakers, checkpointing, graceful degradation, compensation/rollback, and human escalation patterns.

**Time to initialize**: ~5 minutes

## Directory Structure

```
agent-error-recovery-designer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Implementing the patterns requires:
- Python 3.11+ (for async patterns)
- Optional: Redis (for distributed state), structlog (for observability)

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

1. Copy SKILL.md content to your AI assistant
2. Describe your agent workflow and failure modes
3. AI will design a custom error recovery system

## Compatibility

Tested with: Claude Desktop, Claude Code, Cursor, VS Code Copilot, Windsurf

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{agent_type}}` | `multi-step workflow agent with API integrations` | Agent type |
| `{{failure_tolerance}}` | `less than 1% end-to-end failure rate` | Failure tolerance |
| `{{recovery_strategy}}` | `automatic retry with human escalation fallback` | Recovery approach |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
