---
name: "Agent Prompt Chain Designer"
version: "1.0"
---

# Initialization Manifest

## Purpose
Designs production-grade prompt chains for AI agent workflows. Takes a workflow description and available tools, produces a complete chain blueprint with prompts, tool schemas, validation gates, error handling, and cost estimates.

## Structure

| Section | Content |
|---------|---------|
| 1. Chain Design Intake | Extract workflow, tools, model constraints, quality requirements |
| 2. Chain Patterns | 8 patterns: Sequential, ReAct, CoT+Verify, ToT, Fan-Out, Refinement, Router, Map-Reduce |
| 3. Prompt Engineering | Output schemas, context compression, role clarity, escape hatches, anti-hallucination |
| 4. Tool Integration | Tool definitions, selection heuristics, call validation |
| 5. Validation Gates | Schema, quality, safety, budget gates between steps |
| 6. Error Handling | 7 failure modes with recovery strategies |
| 7. State Management | Chain state schema, checkpointing |
| 8. Cost Optimization | Model tiering, caching, early termination, pruning, batching |
| 9. Testing | Unit, chain, regression tests with evaluation metrics |
| 10. Response Format | 8-section blueprint template |
| 11. Anti-Patterns | 8 common mistakes with fixes |

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| my_task | Task or workflow for the chain | (required) |
| my_tools | Available tools/APIs | web search, code execution |
| my_pattern | Preferred chain pattern | recommend |
| my_model | Target LLM | Claude |

## Files
- `index.md` -- Hugo page with full skill_content
- `SKILL.md` -- Condensed documentation
- `INIT.md` -- This manifest

## Compatibility
- Claude (Sonnet, Opus, Haiku)
- ChatGPT (GPT-4o, GPT-4o-mini)
- Gemini (Pro, Flash)
- GitHub Copilot Chat
