---
title: "Agent Prompt Chain Designer"
description: "Design robust prompt chains for AI agents using ReAct, CoT, ToT, and tool-use patterns"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "advanced"
variables:
  - my_task: "Task or workflow to build a prompt chain for"
  - my_tools: "Available tools (web search, code execution, etc.)"
  - my_pattern: "Preferred pattern (ReAct, sequential, branching, parallel, recommend)"
  - my_model: "Target LLM (Claude, GPT-4o, Gemini, Llama, multi-model)"
---

# Agent Prompt Chain Designer

## What This Skill Does

Designs complete, production-ready prompt chains for AI agent workflows. Covers 8 chain patterns, tool integration, validation gates, error handling, cost optimization, and testing strategies.

## 8 Chain Patterns

1. **Sequential Chain** -- Linear pipeline where each prompt feeds the next
2. **ReAct Loop** -- Think → Act (tool call) → Observe → repeat
3. **Chain-of-Thought with Verification** -- Reason step-by-step, then verify logic
4. **Tree of Thoughts** -- Explore multiple paths, evaluate, select best
5. **Parallel Fan-Out** -- Split work across parallel prompts, merge results
6. **Refinement Loop** -- Generate → Critique → Revise → Quality check
7. **Router Chain** -- Classify input, dispatch to specialized sub-chain
8. **Map-Reduce** -- Process items individually, aggregate results

## How to Use

1. Describe your end-to-end workflow
2. List available tools/APIs
3. Receive complete chain blueprint with every prompt, tool call, and decision point

## Output Includes

1. Chain Overview (pattern, cost estimate, latency)
2. Chain Diagram (ASCII)
3. Step-by-Step Specification (complete prompts, schemas, validation)
4. Tool Definitions (full schemas)
5. State Schema (checkpointing support)
6. Error Recovery Plan
7. Cost Estimate (per-step breakdown with model tiering)
8. Testing Plan (test cases, metrics, regression fixtures)
