---
name: ai-agent-designer
version: 2.0.0
---

# AI Agent Designer - Initialization

Architect production-grade AI agents with Plan-then-Execute patterns, multi-agent coordination, error recovery, and framework selection guidance based on peer-reviewed research.

## Package Structure

```
ai-agent-designer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Installation Steps

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r ai-agent-designer/ ~/.claude/skills/ai-agent-designer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Start describing your agent requirements

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{max_planning_steps}}` | `10` | Maximum steps in agent plans (1-50) |
| `{{max_execution_retries}}` | `3` | Retry attempts before fallback (1-10) |
| `{{execution_timeout_seconds}}` | `300` | Tool execution timeout (10-3600) |
| `{{enable_reflection}}` | `true` | Whether agent iterates to improve quality |
| `{{agent_communication_mode}}` | `json_structured` | Inter-agent message format |
| `{{memory_context_window}}` | `10000` | Max tokens in agent context (1000-50000) |

## Quick Usage Examples

### Design a Multi-Agent Code Review System

```
Design a production-ready multi-agent system for automated code review:

Requirements:
- Coordinator agent orchestrates 4 specialist agents
- Code Analysis Agent: Finds bugs, security issues, code smells
- Style Agent: Checks formatting, naming conventions
- Test Coverage Agent: Analyzes test coverage gaps
- Summary Agent: Synthesizes findings into actionable report

Constraints:
- Handle GitHub API rate limits with exponential backoff
- Max 10 minutes execution time
- Token budget: 50,000 tokens total
- Must recover gracefully if one agent fails
```

### Create a Research Agent with Reflection

```
Build an iterative research agent that:
- Takes a research question as input
- Searches multiple sources (web, academic, internal docs)
- Synthesizes findings into a report
- Evaluates report quality and iterates if needed
- Returns final report with citations

Must handle: source unavailability, conflicting information, quality thresholds
```

## Architecture Patterns Covered

| Pattern | Best For |
|---------|----------|
| **ReAct** | Simple tasks, quick prototypes |
| **Plan-then-Execute** | Complex multi-step tasks, security-critical apps |
| **Hierarchical Multi-Agent** | Complex domains, parallel execution |
| **Reflection Loops** | High-quality output, iterative refinement |
| **Tool-Orchestrating** | API integrations, external service coordination |

## Framework Recommendations

| Use Case | Recommended |
|----------|-------------|
| Quick Prototype | Simpliflow or CrewAI |
| Tool Integration | LangChain |
| Complex Workflows | LangGraph |
| Multi-Agent Systems | AutoGen |
| Production Deployment | LangGraph + custom |

## Related Skills

- **Multi-Agent Workflow Builder** - Orchestrate multiple agents
- **Agent Guardrails & Safety** - Safety constraints and security
- **Agent Memory Architect** - Memory systems for agents
- **Agent Observability & Monitoring** - Tracing and alerting
- **Autonomous Task Planner** - Self-directing task decomposition

## Research Foundation

Based on 10 peer-reviewed papers including:
- Agent Design Pattern Catalogue (18 patterns)
- Plan-then-Execute Resilient Architecture
- AutoGen Multi-Agent Framework
- OctoTools Hierarchical Planning

---
Downloaded from [Find Skill.ai](https://findskill.ai)
