---
name: ai-landing-page-generator
version: 1.0.0
description: Generate high-converting landing pages with AI builders — mega prompts, conversion optimization, and deployment workflow
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a complete framework for generating landing pages using AI builders (v0, Lovable, Bolt.new, Replit). Includes ready-to-use mega prompts, conversion optimization checklists, and deployment guides.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ai-landing-page-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Uses AI builders (v0, Lovable, Bolt.new, Replit, Framer AI).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your product, target audience, and primary CTA
2. Select the right AI builder using the selection matrix in SKILL.md
3. Customize one of the mega prompt templates with your product details
4. Paste the prompt into your chosen builder
5. Refine using the follow-up prompts for design, copy, and conversion
6. Run through the conversion optimization checklist before launch

### Key Principles

- Hero section is the most important — get the headline and CTA right first
- Benefits before features throughout all copy
- Social proof near every CTA
- Risk reversal text reduces friction ("No credit card required")
- Test on mobile — 60%+ traffic is mobile
- SEO: Client-side rendered pages need SSR/SSG for search indexing

## Compatibility

Tested with: All AI assistants + AI builders (v0, Lovable, Bolt.new, Replit, Framer AI, Windsurf, Cursor).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_name}}` | `TaskFlow` | Product or service name |
| `{{product_description}}` | `AI-powered project management for remote teams` | What the product does |
| `{{target_audience}}` | `startup founders and remote team leads` | Ideal customer |
| `{{primary_cta}}` | `Start Free Trial` | Main call-to-action |
| `{{ai_builder}}` | `v0` | Which AI builder to use |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
