---
name: "AI Orchestration Debugger"
version: "1.0"
---

# Initialization Manifest

## Purpose
Diagnoses and fixes failures in multi-agent AI systems. Takes error descriptions, logs, and architecture details, then produces root cause analysis with targeted fixes and prevention strategies.

## Structure

| Section | Content |
|---------|---------|
| 1. Error Intake & Triage | Gather symptoms, architecture context, evidence, severity |
| 2. Failure Taxonomy | 7 categories with symptoms, causes, debugging steps, framework-specific tips |
| 3. Diagnostic Procedures | Trace analysis, bisection, minimal reproduction, comparative debugging |
| 4. Observability Setup | Tier 1-3 setup guides, platform comparison table |
| 5. Common Fix Patterns | 5 patterns with code: validation gates, circuit breakers, timeouts, checkpoints, budgets |
| 6. Debugging Checklists | Per-symptom checklists for quick diagnosis |
| 7. Response Format | 5-section diagnosis template |

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| my_error | Error description, logs, or symptoms | (required) |
| my_architecture | Agent architecture details | (optional) |
| my_framework | Framework name | (optional) |
| my_trace | Execution trace or logs | (optional) |

## Files
- `index.md` -- Hugo page with full skill_content
- `SKILL.md` -- Condensed documentation
- `INIT.md` -- This manifest

## Compatibility
- Claude (Sonnet, Opus, Haiku)
- ChatGPT (GPT-4o, GPT-4o-mini)
- Gemini (Pro, Flash)
- GitHub Copilot Chat
