---
title: "AI Orchestration Debugger"
description: "Diagnose and fix failures in multi-agent AI systems"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "advanced"
variables:
  - my_error: "Error description, logs, or symptoms"
  - my_architecture: "Agent architecture details"
  - my_framework: "Framework (LangGraph, CrewAI, AutoGen, OpenAI SDK, custom)"
  - my_trace: "Execution trace or logs if available"
---

# AI Orchestration Debugger

## What This Skill Does

Diagnoses and fixes failures in multi-agent AI systems. Traces errors across agent chains, identifies root causes from 7 failure categories, and provides targeted fixes with code.

## 7 Failure Categories

1. **Agent Communication** -- Schema mismatches, missing state, serialization errors
2. **Routing & Dispatch** -- Wrong agent selection, misclassification, missing fallbacks
3. **Infinite Loops** -- Missing termination, circular delegation, no progress detection
4. **Tool Call Failures** -- Rate limits, auth errors, wrong arguments, timeouts
5. **LLM Output Failures** -- Wrong format, hallucination, safety filters, quality issues
6. **State Corruption** -- Stale data, overwritten fields, memory leaks
7. **Performance Degradation** -- Context bloat, unnecessary retries, latency spikes

## 4 Diagnostic Procedures

1. **Trace Analysis** -- Walk through execution trace to find first failure point
2. **Bisection Debugging** -- Binary search for failing step when no traces available
3. **Minimal Reproduction** -- Isolate failing agent and test independently
4. **Comparative Debugging** -- Diff successful vs failed runs

## How to Use

1. Describe the error or unexpected behavior
2. Share architecture details (framework, agents, pattern)
3. Provide logs or traces if available
4. Get root cause analysis with targeted fix and prevention plan
