---
name: bolt-new-app-builder
version: 1.0.0
description: Build full-stack apps with Bolt.new using optimized mega prompts and deployment workflows
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill helps you build full-stack web and mobile applications using Bolt.new's AI-powered vibe coding platform. It provides mega prompt templates, build sequence strategies, and troubleshooting guides for effective AI-assisted development.

**Time to initialize**: ~2 minutes

## Directory Structure

```
bolt-new-app-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Bolt.new runs in the browser — no local installation needed.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started with Bolt.new

1. Visit [bolt.new](https://bolt.new) in your browser
2. Sign up or log in with GitHub
3. Use the mega prompt framework from SKILL.md to describe your app
4. Iterate with follow-up prompts for additional features
5. Deploy to Bolt Cloud or export to GitHub

### Recommended Workflow

1. **Plan**: Use this skill to generate a mega prompt for your app idea
2. **Build**: Paste the mega prompt into Bolt.new and let AI generate the foundation
3. **Iterate**: Use focused follow-up prompts to add features one at a time
4. **Deploy**: Ship to Bolt Cloud or connect to Netlify/Vercel via GitHub

## Compatibility

Tested with: Claude, ChatGPT, Copilot (for prompt generation). Bolt.new platform for building.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_idea}}` | `a task management SaaS with team collaboration` | App idea or project |
| `{{tech_preferences}}` | `React with Supabase backend and Tailwind CSS` | Preferred tech stack |
| `{{deployment_target}}` | `Bolt Cloud for quick launch` | Deployment target |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
