---
name: chrome-extension-vibe-builder
version: 1.0.0
description: Build Chrome extensions with AI — Manifest V3 architecture, service workers, content scripts, popup UI, and Chrome Web Store submission
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a complete framework for building Chrome extensions using AI-assisted development (vibe coding). Covers Manifest V3 architecture, service worker patterns, content script injection, popup UI design, storage management, testing, and Chrome Web Store submission.

**Time to initialize**: ~5 minutes

## Directory Structure

```
chrome-extension-vibe-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Uses AI tools (Cursor, Claude Code, Bolt.new, Lovable, Windsurf).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your extension idea and identify which components are needed
2. Use the architecture diagram to plan service worker, content scripts, and popup
3. Generate manifest.json using the template with minimum required permissions
4. Build each component using AI builder prompts from SKILL.md
5. Test via chrome://extensions with Developer mode enabled
6. Package and submit to Chrome Web Store

### Key Principles

- Manifest V3 only — Manifest V2 is deprecated
- Service workers are event-driven and terminate after 30 seconds of inactivity
- Store all state in chrome.storage, never in global variables
- Use Shadow DOM for content script UI to prevent CSS conflicts
- Route API calls through the service worker to avoid CORS issues
- Request minimum permissions — each permission increases the install warning

## Compatibility

Tested with: All AI assistants + AI IDEs (Cursor, Windsurf, Claude Code) + AI builders (Bolt.new, Lovable).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{extension_name}}` | `PageSaver Pro` | Chrome extension name |
| `{{extension_purpose}}` | `saves web pages for offline reading with AI-generated summaries` | What the extension does |
| `{{ai_tool}}` | `Cursor` | Which AI tool to build with |
| `{{key_features}}` | `one-click save, AI summary, offline reading` | 3 main features |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
