---
name: full-stack-app-architect
version: 1.0.0
description: Design production-ready full-stack architectures — tech stack selection, system design, database modeling, API patterns, and deployment
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive architecture design framework for full-stack applications built with AI tools. Covers the 2026 recommended tech stack, architecture decision framework, database schema templates, project structure, deployment patterns, security checklists, and scaling strategies.

**Time to initialize**: ~5 minutes

## Directory Structure

```
full-stack-app-architect/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). References: Next.js, TypeScript, Tailwind CSS, shadcn/ui, Supabase, tRPC, Vercel.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your app type, scale, team size, and budget constraints
2. Use the architecture decision framework to make key choices
3. Select tech stack from the tier recommendations
4. Design your database schema using the provided templates
5. Follow the 5-phase build sequence with AI tools
6. Deploy and iterate

### Key Principles

- Start with a monolith (Next.js App Router IS your monolith)
- PostgreSQL via Supabase handles 95% of database needs
- TypeScript everywhere for AI-friendly, type-safe code
- Deploy from day 1 (Vercel makes this trivial)
- Security is non-negotiable: RLS, input validation, HTTPS, env vars
- Optimize after you have users, not before

## Compatibility

Tested with: All AI assistants + AI IDEs (Cursor, Windsurf, Claude Code) + AI builders (Bolt.new, Lovable, Replit).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_name}}` | `TaskBoard` | Application name |
| `{{app_type}}` | `SaaS project management tool with real-time collaboration` | Type of application |
| `{{scale}}` | `MVP to 10,000 users` | Expected scale |
| `{{team_size}}` | `solo founder using AI tools` | Development team size |
| `{{constraints}}` | `TypeScript, deploy on Vercel, budget under $50/month initially` | Technical constraints |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
