---
name: lovable-app-prompt-guide
version: 1.0.0
description: Master Lovable.dev prompting for building full-stack apps with AI
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill teaches optimized prompting strategies for Lovable.dev, the AI-powered full-stack app builder. Covers the 4-phase methodology, integration patterns, and iterative build workflows.

**Time to initialize**: ~2 minutes

## Directory Structure

```
lovable-app-prompt-guide/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Lovable.dev runs in the browser at lovable.dev.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Visit [lovable.dev](https://lovable.dev) and create an account
2. Use the prompt templates from SKILL.md to describe your app
3. Follow the 4-phase methodology: Foundation → Systems Thinking → Precision → Iteration
4. End initial prompts with "Ask me any questions you need" to activate Plan mode
5. Deploy directly or export to GitHub

### Key Tips

- Build by component, not full pages
- Use real content instead of placeholder text
- Set up authentication first before adding features
- Make one change per follow-up prompt
- Use style buzzwords consistently (minimal, premium, playful, etc.)

## Compatibility

Tested with: Claude, ChatGPT, Copilot (for prompt generation). Lovable.dev platform for building.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_idea}}` | `a habit tracking app with streaks` | App idea |
| `{{design_style}}` | `minimal and clean with soft colors` | Design style |
| `{{backend_choice}}` | `Supabase for auth, database, and real-time` | Backend |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
