---
name: mobile-app-vibe-coder
version: 1.0.0
description: Build native iOS and Android apps with AI — React Native, Expo, vibe coding, and App Store deployment
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a complete framework for building native mobile apps using AI-assisted development. Covers tool selection, React Native + Expo architecture, screen design, navigation patterns, Supabase backend, push notifications, in-app purchases, offline-first architecture, and App Store submission.

**Time to initialize**: ~5 minutes

## Directory Structure

```
mobile-app-vibe-coder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Uses AI tools (Cursor, Bolt.new, Natively, Rork, Replit) and frameworks (React Native, Expo).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your app idea, target audience, and platforms (iOS/Android/both)
2. Select an AI builder using the tool comparison matrix
3. Design the screen flow and navigation architecture
4. Use the mega prompt templates to generate your app
5. Refine with iterative prompts for each screen
6. Build with EAS and submit to App Store/Play Store

### Key Principles

- Use Expo for simpler builds and deployments (no Xcode/Android Studio required)
- Start with Supabase for backend (auth, database, storage in one service)
- Design screens mobile-first with proper safe area handling
- Use FlashList for lists and expo-image for images
- Implement offline-first with local SQLite + cloud sync
- Test on physical devices, not just simulators

## Compatibility

Tested with: All AI assistants + AI builders (Cursor, Bolt.new, Natively, Rork, Replit, Windsurf).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{app_name}}` | `FitTrack` | Mobile app name |
| `{{app_description}}` | `workout tracking app...` | What the app does |
| `{{target_platform}}` | `iOS and Android` | Target platforms |
| `{{ai_builder}}` | `Cursor with Expo` | AI tool to build with |
| `{{backend}}` | `Supabase` | Backend service |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
