---
name: "Multi-Agent Workflow Architect"
version: "1.0"
---

# Initialization Manifest

## Purpose
Designs production-ready multi-agent AI system architectures. Takes a use case description and constraints, then produces a complete blueprint covering orchestration pattern selection, agent definitions, state management, error handling, cost optimization, and deployment architecture.

## Structure

| Section | Content |
|---------|---------|
| 1. Intake & Scoping | Extract problem statement, agent roles, constraints, framework preference |
| 2. Orchestration Patterns | 7 patterns: Supervisor, Router, Sequential, Hierarchical, Swarm, Fan-Out, Agents-as-Tools |
| 3. Framework Selection | Decision tree for LangGraph, CrewAI, AutoGen, OpenAI SDK, Strands, Swarms |
| 4. Agent Definition Templates | Structured agent cards with role, tools, schemas, error handling |
| 5. State Management | Shared state schema, checkpoint strategies, persistence |
| 6. Communication Protocol | Shared state, message passing, event-driven options |
| 7. Error Handling | Failure taxonomy, circuit breakers, retry strategies, graceful degradation |
| 8. Observability | Logging, tracing, metrics, dashboards |
| 9. Cost Optimization | Model tiering, prompt caching, early exit, context compression, budgets |
| 10. Testing & Evaluation | Unit, integration, e2e, adversarial tests with thresholds |
| 11. Security & Guardrails | Input validation, inter-agent trust, tool safety, data handling |
| 12. Deployment Architecture | Monolithic, microservices, serverless, queue-based options |
| 13. Response Format | 10-section blueprint template |
| 14. Anti-Patterns | 8 common mistakes with fixes |
| 15. Quick-Start Recipes | 5 ready-made architectures with cost estimates |

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| my_use_case | Specific use case or problem | (required) |
| my_framework | Preferred framework | undecided |
| my_agent_count | Estimated number of agents | 3-5 |
| my_constraints | Deployment constraints | (optional) |

## Files
- `index.md` -- Hugo page with full skill_content (500+ lines)
- `SKILL.md` -- Condensed skill documentation
- `INIT.md` -- This initialization manifest

## Post-Init Steps

### Claude Code
```bash
# Copy skill content to clipboard
cat SKILL.md | pbcopy
# Or use directly in conversation
```

### Other AI Assistants
1. Open SKILL.md
2. Copy the full content
3. Paste as system prompt or conversation starter
4. Describe your multi-agent use case

## Compatibility
- Claude (Sonnet, Opus, Haiku)
- ChatGPT (GPT-4o, GPT-4o-mini)
- Gemini (Pro, Flash)
- GitHub Copilot Chat

## Research Sources
- DataCamp: CrewAI vs LangGraph vs AutoGen comparison
- Kore.ai: Multi-agent orchestration patterns
- AWS: Agents as Tools and Strands collaboration patterns
- Swarms: Swarm architecture documentation
- Digital Applied: Agent orchestration workflow guide
- Codecademy: Top AI agent frameworks 2025
- SpaceO: Enterprise agentic AI frameworks guide
