---
title: "Multi-Agent Workflow Architect"
description: "Design production-ready multi-agent AI systems with proven orchestration patterns"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "advanced"
variables:
  - my_use_case: "My specific use case or problem"
  - my_framework: "Preferred framework (CrewAI, LangGraph, AutoGen, OpenAI Agents SDK, undecided)"
  - my_agent_count: "Estimated number of agents (3-5)"
  - my_constraints: "Deployment constraints (latency, cost, cloud, compliance)"
---

# Multi-Agent Workflow Architect

## What This Skill Does

Designs complete multi-agent AI system architectures from requirements to deployment blueprints. Covers 7 orchestration patterns, 6 frameworks, state management, error handling, cost optimization, and production observability.

## 7 Orchestration Patterns

1. **Supervisor** -- Central orchestrator delegates to specialized agents. Best for 3-8 agent workflows requiring quality gates.
2. **Router** -- Lightweight classifier dispatches to one specialist. Best for support bots and low-latency routing.
3. **Sequential Pipeline** -- Fixed-order chain where each agent's output feeds the next. Best for content and data pipelines.
4. **Hierarchical** -- Multi-level supervision with team leads and workers. Best for 10+ agent enterprise systems.
5. **Swarm** -- Decentralized peer-to-peer agents with emergent behavior. Best for autonomous exploration.
6. **Parallel Fan-Out/Fan-In** -- Split work across parallel agents, aggregate results. Best for independent subtasks.
7. **Agents-as-Tools** -- Primary agent calls specialists as tools. Best for gradual complexity scaling.

## Framework Decision Tree

- Complex stateful workflows with branching → **LangGraph**
- Role-based team collaboration → **CrewAI**
- Microsoft/Azure ecosystem → **AutoGen**
- Simple agent handoffs → **OpenAI Agents SDK**
- AWS-native → **Strands Agents SDK**
- Massive swarm (50+ agents) → **Swarms framework**

## How to Use

1. Describe your use case and what you want agents to accomplish
2. Share constraints: framework preference, cloud, latency, budget
3. Receive a complete blueprint: architecture diagram, agent cards, state schema, cost estimate, deployment plan

## Example Prompts

- "Design a multi-agent content pipeline: research → write → fact-check → SEO optimize → publish"
- "Architect a customer support system with routing to billing, technical, and sales agents"
- "I need a code review pipeline with security, style, logic, and test coverage agents on LangGraph"
- "Help me build a data processing fan-out system that analyzes 100 documents in parallel"

## Output Includes

1. Executive Summary (pattern + framework choice)
2. Architecture Diagram (ASCII)
3. Agent Cards (role, tools, schemas, error handling for each)
4. State Schema (TypedDict with full annotations)
5. Communication Protocol
6. Error Handling Plan (circuit breakers, retries, degradation)
7. Cost Estimate (model tiering, per-run and monthly projections)
8. Testing Strategy (unit, integration, e2e, adversarial)
9. Deployment Recommendation (monolithic → microservices → serverless)
10. Implementation Roadmap (MVP → production → scale)
