---
name: no-code-saas-builder
version: 1.0.0
description: Build complete SaaS apps with AI — multi-tenant, billing, RBAC, onboarding
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a complete SaaS architecture framework for building subscription-based applications using AI builders and no-code tools. Covers multi-tenant data models, Stripe billing, RBAC, onboarding, and admin dashboards.

**Time to initialize**: ~5 minutes

## Directory Structure

```
no-code-saas-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Uses AI builders (Bolt.new, Lovable, Replit) and Stripe.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your SaaS idea, target user, and pricing model
2. Use the multi-tenant data model template for your database
3. Follow the 5-step build sequence with the provided AI builder prompts
4. Set up Stripe billing with the subscription prompt templates
5. Add onboarding flow and RBAC

## Compatibility

Tested with: All AI assistants + AI builders (Bolt.new, Lovable, Replit, Bubble).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{saas_idea}}` | `client portal for agencies` | SaaS product idea |
| `{{pricing_model}}` | `Free, Pro $29/mo, Business $79/mo` | Pricing tiers |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
