---
name: "RAG Pipeline Builder"
version: "1.0"
---

# Initialization Manifest

## Purpose
Designs production-ready RAG pipelines. Takes data sources, use case, and constraints, produces complete architecture with chunking, embedding, retrieval, generation, and evaluation strategies.

## Structure

| Section | Content |
|---------|---------|
| 1. Requirements Intake | Data profile, query profile, quality requirements, tech constraints |
| 2. Architecture Tiers | Naive, Advanced, Agentic, Graph RAG with selection guide |
| 3. Document Processing | Parsers by type, pre-processing pipeline |
| 4. Chunking Strategy | 4 strategies with code, size tuning guide |
| 5. Embedding Selection | Model comparison table, selection guide, best practices |
| 6. Vector Database | Database comparison, selection guide |
| 7. Retrieval Strategies | 6 strategies with code: vector, hybrid, multi-query, HyDE, reranking, CRAG |
| 8. Generation Prompt | Grounded generation, citations, multi-hop |
| 9. Evaluation | Retrieval + generation metrics, tools, automated pipeline |
| 10. Production Checklist | Functionality, performance, quality, security, operations |
| 11. Response Format | 10-section blueprint template |

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| my_data | Data sources | (required) |
| my_use_case | Use case | (required) |
| my_scale | Scale | (optional) |
| my_stack | Tech stack | Python |

## Compatibility
- Claude, ChatGPT, Gemini, Copilot
