---
title: "RAG Pipeline Builder"
description: "Design production-ready RAG pipelines with optimal chunking, embedding, retrieval, and generation"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "advanced"
variables:
  - my_data: "Data sources (PDFs, docs, code, database, website)"
  - my_use_case: "Use case (chatbot, search, Q&A, code assistant)"
  - my_scale: "Scale (document count, queries per day)"
  - my_stack: "Tech stack (Python, TypeScript, cloud provider)"
---

# RAG Pipeline Builder

## What This Skill Does

Designs complete RAG systems from document processing to production deployment. Covers 4 architecture tiers, 6 retrieval strategies, chunking optimization, embedding selection, vector database comparison, and evaluation frameworks.

## 4 Architecture Tiers

1. **Naive RAG** -- Quick start: chunk → embed → search → generate
2. **Advanced RAG** -- Production: hybrid search, reranking, citations, query rewriting
3. **Agentic RAG** -- Complex: agent-driven query planning, multi-source, CRAG
4. **Graph RAG** -- Relationship-rich: knowledge graph + vector search

## Key Decisions Covered

- Chunking strategy (fixed, semantic, structure-aware, contextual)
- Embedding model (OpenAI, Cohere, Voyage, BGE, E5, Jina)
- Vector database (Pinecone, Qdrant, Weaviate, Milvus, pgvector, Chroma)
- Retrieval strategy (vector, hybrid, multi-query, HyDE, reranking, CRAG)
- Generation prompt with grounding and citations

## How to Use

1. Describe your data sources and use case
2. Share scale, accuracy, and budget constraints
3. Receive complete pipeline architecture with code and deployment plan
