---
name: react-typescript-supabase-fullstack
version: 1.0.0
description: Build full-stack applications with React TypeScript frontend, Node.js Express backend, and Supabase
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive patterns for building full-stack applications with React TypeScript on the frontend, Node.js Express on the backend, and Supabase for database, authentication, storage, and real-time features.

**Time to initialize**: ~3 minutes

## Overview

This skill enables you to:
- Set up type-safe Supabase clients for both frontend and backend
- Implement authentication with React context and JWT verification
- Create custom React hooks for data fetching and real-time subscriptions
- Build secure Node.js Express APIs with Supabase Admin SDK
- Configure Row Level Security (RLS) policies
- Handle file uploads with Supabase Storage

## Directory Structure

```
react-typescript-supabase-fullstack/
├── SKILL.md                  # Main skill instructions
└── INIT.md                   # This file
```

## Dependencies

### Frontend (React TypeScript)
```bash
# Core dependencies
npm install @supabase/supabase-js

# Dev dependencies
npm install -D typescript @types/react @types/react-dom
```

### Backend (Node.js Express)
```bash
# Core dependencies
npm install express cors helmet express-rate-limit jsonwebtoken @supabase/supabase-js

# Dev dependencies
npm install -D typescript @types/express @types/cors @types/jsonwebtoken ts-node nodemon
```

### Supabase CLI (for type generation)
```bash
npm install -g supabase
```

## Files to Generate

This is a prompt-based skill. The SKILL.md contains all code patterns inline.

Key patterns included:
- Supabase client setup (frontend with anon key, backend with service role)
- AuthContext with React hooks
- Custom data fetching hooks with TypeScript generics
- Real-time subscription hooks
- File upload hooks
- JWT authentication middleware for Express
- API routes with RLS-respecting queries
- SQL migrations for schema and RLS policies

## Quick Reference

### Type Generation Command
```bash
npx supabase gen types typescript --project-id "your-project-id" > src/types/database.types.ts
```

### Key Environment Variables

Frontend (.env):
```
VITE_SUPABASE_URL=
VITE_SUPABASE_ANON_KEY=
```

Backend (.env):
```
SUPABASE_URL=
SUPABASE_SERVICE_ROLE_KEY=
SUPABASE_JWT_SECRET=
PORT=3001
```

## Post-Init Steps

### For Claude Code Users
```bash
# Copy to your skills directory
cp -r react-typescript-supabase-fullstack/ ~/.claude/skills/
```

### For Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with:
- claude
- chatgpt
- gemini
- copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{project_name}}` | `my-fullstack-app` | Name of your full-stack project |
| `{{backend_framework}}` | `express` | Node.js backend framework |

## Key Concepts

### Two Supabase Clients

1. **Frontend Client** (anon key): Used in React, respects RLS
2. **Backend Admin Client** (service role): Bypasses RLS, only for server-side

### Row Level Security

Always enable RLS on tables and use `auth.uid()` in policies to restrict access to the authenticated user's data.

### Type Safety

Generate types from your database schema to get end-to-end type safety across frontend, backend, and database queries.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
