---
name: "Tool Calling Pattern Library"
version: "1.0"
---

# Initialization Manifest

## Purpose
Reference and design assistant for LLM function calling and tool use. Provides patterns for tool definitions, execution, error handling, security, structured output, and cross-platform compatibility.

## Structure

| Section | Content |
|---------|---------|
| 1. Fundamentals | How tool calling works, three-pillar framework |
| 2. Tool Definition Patterns | Comprehensive descriptions, families, discriminated unions |
| 3. Platform-Specific | Claude, OpenAI GPT, Google Gemini code examples |
| 4. Error Handling | Graceful failure, retry, validation patterns |
| 5. Security | Sanitization, confirmation, permissions, audit, rate limiting |
| 6. Structured Output | Pydantic, Zod, Instructor multi-provider patterns |
| 7. Scale Management | Dynamic selection, categories, MCP integration |
| 8. Parallel & Chained | Concurrent execution, dependent tool chains |
| 9. Testing | Selection accuracy, argument quality, error recovery |
| 10. Response Format | 5-section integration blueprint |

## Variables

| Variable | Description | Default |
|----------|-------------|---------|
| my_tools | Tools or APIs to connect | (required) |
| my_platform | Target platform | Claude |
| my_use_case | Use case | (optional) |
| my_language | Programming language | Python |

## Compatibility
- Claude, ChatGPT, Gemini, Copilot
