---
title: "Tool Calling Pattern Library"
description: "Battle-tested patterns for LLM function calling, tool use, and structured output"
version: "1.0"
platforms: ["claude", "chatgpt", "gemini", "copilot"]
difficulty: "intermediate"
variables:
  - my_tools: "Tools or APIs to connect to an LLM"
  - my_platform: "Target platform (Claude, OpenAI, Gemini, multi-platform)"
  - my_use_case: "Use case (chatbot, agent, pipeline, automation)"
  - my_language: "Programming language (Python, TypeScript, Go)"
---

# Tool Calling Pattern Library

## What This Skill Does

Reference library for implementing LLM function calling and tool use. Covers tool definitions, execution handling, error recovery, security, structured output, and cross-platform compatibility.

## Key Patterns

- Tool definition with comprehensive descriptions
- Three-pillar framework (data access, computation, actions)
- Platform-specific code (Claude, OpenAI, Gemini)
- Error handling (graceful failure, retry, validation)
- Security (sanitization, permissions, confirmation, audit, rate limiting)
- Structured output (Pydantic, Zod, Instructor)
- Scale management (dynamic selection, MCP, routing)
- Testing (selection accuracy, argument quality, error recovery)

## How to Use

1. Describe what tools/APIs you want to connect
2. Specify your target platform
3. Get complete tool definitions, execution code, security, and tests
