---
name: v0-ui-component-generator
version: 1.0.0
description: Generate production-ready React components using Vercel's v0 with optimized prompts
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill teaches optimized prompting strategies for Vercel's v0, the AI agent for generating React components, full-stack Next.js apps, and polished UIs with shadcn/ui and Tailwind CSS.

**Time to initialize**: ~2 minutes

## Directory Structure

```
v0-ui-component-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). v0 runs in the browser at v0.app.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Visit [v0.app](https://v0.app) and create an account
2. Use the prompt templates from SKILL.md to generate components
3. Copy generated code into your project or use `npx v0 add [url]`
4. Install required shadcn/ui components: `npx shadcn@latest add [component]`

### Key Tips

- Use specific UI terminology (combobox, sheet, command palette)
- Set design direction in every prompt (minimal, premium, playful)
- Break complex UIs into smaller component prompts
- Use selection mode for targeted visual edits
- Include realistic sample data, not placeholder text

## Compatibility

Tested with: Claude, ChatGPT, Copilot (for prompt generation). v0.app for generation.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{component_need}}` | `a pricing page with three tiers` | Component to generate |
| `{{design_system}}` | `shadcn/ui with Tailwind CSS` | Design system |
| `{{project_context}}` | `Next.js 14 App Router` | Project framework |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
