---
name: vibe-coding-mvp-launcher
version: 1.0.0
description: Plan, build, and launch validated MVPs using vibe coding with AI tools
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a complete framework for launching MVPs using vibe coding — from idea definition and architecture planning through building, validating, and launching with AI app builders. Combines lean startup methodology with modern AI development tools.

**Time to initialize**: ~5 minutes

## Directory Structure

```
vibe-coding-mvp-launcher/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Uses various AI tools (Bolt.new, Lovable, Replit, Cursor, v0).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your product idea using the Problem Statement template
2. Use the Feature Prioritization Matrix to scope your MVP
3. Choose your tech stack and AI tools from the selection matrix
4. Follow the 6-phase framework: Define → Architecture → Build → Validate → Launch → Iterate
5. Use the prompt templates for each phase

### Key Principles

- If a feature doesn't help users accomplish the core task, cut it
- Build in priority order: Foundation → Core Feature → Payments → Polish
- Validate with 5-10 real users before public launch
- Track technical debt but don't fix it pre-launch
- Security checklist is non-negotiable before going live

## Compatibility

Tested with: All AI assistants (Claude, ChatGPT, Copilot) + AI builders (Bolt.new, Lovable, Replit, v0).

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_idea}}` | `SaaS tool for freelancers` | Product idea |
| `{{timeline}}` | `working MVP in one weekend` | Launch timeline |
| `{{monetization}}` | `freemium with Stripe subscriptions` | Revenue model |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
