---
name: windsurf-cascade-workflow
version: 1.0.0
description: Master Windsurf IDE's Cascade AI agent for autonomous coding workflows
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill teaches advanced Windsurf IDE workflows using Cascade, including Code/Chat modes, real-time context awareness, the memory system, planning capabilities, checkpoints, and MCP integration.

**Time to initialize**: ~3 minutes

## Directory Structure

```
windsurf-cascade-workflow/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Requires Windsurf IDE (windsurf.com).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Download Windsurf IDE from [windsurf.com](https://windsurf.com)
2. Open Cascade with Cmd+L
3. Set up project memories with your conventions
4. Use Chat mode for planning, Code mode for implementation
5. Create checkpoints before major changes

### Key Tips

- Let real-time awareness work — don't over-explain context
- Set up memories early for consistent AI output
- Use "Continue" to keep Cascade going without repeating context
- Use worktrees for simultaneous Cascade instances on same files
- Linter auto-fix is free — always use it

## Compatibility

Tested with: Windsurf IDE (all plans). Prompt templates work with Claude, Copilot.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{project_type}}` | `full-stack web app with React and Node.js` | Project type |
| `{{cascade_mode}}` | `Code mode for implementation, Chat for planning` | Preferred mode |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
