---
name: audience-persona-builder
version: 1.0.0
---

# Audience Persona Builder - Initialization

Build detailed audience personas for creators with demographics, psychographics, behavior analysis, pain point mapping, and platform-specific insights to drive content strategy.

## What This Skill Does

This skill transforms you into an expert audience research strategist capable of:

- **Audience Discovery**: Mining analytics, comments, DMs, surveys, and competitor audiences for raw data
- **Segmentation**: Clustering audiences along knowledge level, engagement depth, and content need axes
- **Deep Persona Development**: Building multi-layered profiles covering demographics, psychographics, behavior, pain points, and desires
- **Platform-Specific Analysis**: Creating per-platform behavior layers for YouTube, Instagram, TikTok, newsletters, and podcasts
- **Interview Guidance**: Structuring 1-on-1 interviews that uncover deep audience insights
- **Strategy Translation**: Converting persona profiles into content plans, product roadmaps, and monetization strategies

## Package Structure

```
audience-persona-builder/
├── SKILL.md          # Main skill prompt (copy to your AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r audience-persona-builder/ ~/.claude/skills/audience-persona-builder/

# Or for Claude Desktop, add to MCP configuration
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom GPT instructions or conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire prompt content
3. Paste as system instructions or initial context

## Variables

Customize these values when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{creator_niche}}` | Your content niche (e.g., personal finance, fitness, tech reviews) | The niche or topic area you create content about |
| `{{primary_platform}}` | YouTube | The main platform where you publish content |
| `{{audience_size}}` | Growing (1K-10K followers) | Your current audience size or growth stage |
| `{{monetization_model}}` | Sponsorships and digital products | How you earn revenue from your audience |
| `{{persona_count}}` | 3 | Number of distinct personas to create (recommended 2-4) |

## Quick Start

After installation, start with one of these prompts:

**Full Persona Build from Scratch**
```
I'm a [niche] creator on [platform] with [X] followers. I monetize through [method]. I want to build [N] detailed audience personas so I can create more targeted content and products. Guide me through the full research and persona building process.
```

**Persona Build with Existing Data**
```
I have analytics data and comment/DM patterns from my [platform] account. Here's what I know about my audience: [paste data summary]. Help me segment this into distinct personas and build full persona cards.
```

**Persona-to-Strategy Translation**
```
I already have [N] audience personas. Here they are: [paste persona summaries]. Now help me translate these into a content strategy, product roadmap, and monetization plan aligned to each persona.
```

**Persona Refresh**
```
I built audience personas [X months] ago but my audience has changed since [growth event / niche shift / new platform]. Help me audit and update my personas with fresh data.
```

## Key Workflows

1. **Audience Discovery from Scratch** - Platform analytics export, comment mining, competitor research, survey design, initial segmentation
2. **Data Synthesis and Segmentation** - Data consolidation, behavioral clustering, segment validation, prioritization
3. **Deep Persona Construction** - Demographics, psychographics, behavior, pain-desire mapping, persona cards
4. **Persona-to-Strategy Translation** - Content audit, ideation sprint, scheduling, product development, sponsorship alignment
5. **Persona Maintenance and Evolution** - Monthly micro-audit, quarterly review, annual rebuild, trigger-based updates

## Expected Outputs

- 2-4 detailed persona cards with demographics, psychographics, behavior, pain points, desires, purchase profile, and content strategy
- Audience segmentation map with prioritization scores
- Pain-desire spectrum (surface, functional, emotional) for each persona
- Platform-specific behavior layers per persona
- Content ideation matrix mapped to personas
- Product opportunity roadmap aligned to persona pain points
- Interview guide and survey template for ongoing research

## Related Skills

- **Personal Brand Builder** - Develop positioning that resonates with your persona segments
- **Content Pillar Mapper** - Organize content themes around persona needs
- **Social Media Content Calendar** - Schedule content tailored to each persona
- **Niche Pivot Planner** - Use persona insights to evaluate niche shifts
- **Newsletter Growth Engine** - Convert persona pain points into subscriber hooks

---

Downloaded from [Find Skill.ai](https://findskill.ai)
