---
name: brand-deal-negotiator
version: 1.0.0
---

# Brand Deal Negotiator

Negotiate higher-paying brand deals with confidence. Get rate cards, negotiation scripts, contract red-flag checks, usage-rights pricing, and counter-offer strategies for YouTube, TikTok, Instagram, and podcasts.

## Structure

- `SKILL.md` - Main skill prompt with complete negotiation framework, rate card builder, contract review checklist, and platform-specific tactics

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r brand-deal-negotiator/ ~/.claude/skills/brand-deal-negotiator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Brand Deal Negotiator")
3. Paste into AI assistant (Claude, ChatGPT, Gemini, Copilot)
4. Share your platform, follower count, average views, engagement rate, and deal details
5. Get rate cards, negotiation scripts, and contract review guidance

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_platform_and_size}}` | `` | Main platform and follower/subscriber count |
| `{{my_niche}}` | `` | Content niche — tech, beauty, finance, gaming, fitness, etc. |
| `{{my_avg_views}}` | `` | Average views or listens per content piece (last 10 posts) |
| `{{my_engagement_rate}}` | `` | Engagement rate as a percentage |
| `{{deal_details}}` | `` | Brand's ask — deliverables, timeline, exclusivity, budget |

## What's Included

### Rate Card Builder
- Platform-specific CPM benchmarks (YouTube, TikTok, Instagram, podcasts, newsletters, LinkedIn)
- Engagement, geographic, niche, and age multipliers
- Three-tier pricing output (Floor, Standard, Premium)
- Clean rate card template ready to send to brands

### Negotiation Scripts
- Inbound DM and email response templates
- Counter-offer scripts at various price gaps
- Product-only / exposure rejection scripts
- Quick-reference phrases for anchoring, justifying, urgency, and walking away

### Contract Red-Flag Checklist
- Critical flags (do not sign)
- Warning flags (negotiate first)
- Negotiable items (standard but improvable)
- Ideal deal structures by creator tier

### Usage Rights & Exclusivity Pricing
- Full pricing matrix: organic, whitelisting, paid amplification, TV/OOH, perpetual, IP transfer
- Exclusivity premiums from 7 days to 12 months
- Response template for usage-rights negotiations

### Counter-Offer Strategies
- Decision tree for any offer level
- "Add value, not discount" framework
- Multi-deal leverage and package discounts
- 6 common scenarios with exact responses

### Platform-Specific Tactics
- YouTube: views-based pricing, Shorts bundles, evergreen value
- TikTok: flat fee strategy, creative control, Spark Ads pricing
- Instagram: Reels-first packages, link-in-bio fees, Collab post premiums
- Podcast: downloads-based pricing, host-read premiums, baked-in vs. dynamic

### Media Kit Template
- Complete one-page media kit structure
- Audience snapshot format
- Past partnership showcase
- Contact and booking section

## Example Usage

**Prompt:**
"A DTC skincare brand reached out on Instagram asking for one dedicated Reel plus three Stories. They said their budget is $800. I have 120K followers, average 40K views per Reel, and 5.2% engagement. My audience is 78% US women aged 22-35. They also want to use my content in their paid ads for 60 days. Walk me through what to counter-offer and exactly what to say."

**Expected Output:**
- Rate calculation: Base CPM ($15 beauty Instagram) x 1.4 (5.2% engagement) x 1.3 (78% US) = ~$27 adjusted CPM
- Base rate for Reel: ~$1,080; Stories add ~$350; whitelisting 60 days adds +40%
- Three-tier quote: Floor $1,800 / Standard $2,250 / With whitelisting $3,150
- Copy-paste counter-offer email addressing the $800 budget gap
- Red flags to watch for in follow-up contract

---
Downloaded from [Find Skill.ai](https://findskill.ai)