---
name: content-repurposing-engine
version: 1.0.0
---

# Initialization

Build automated workflows that transform YouTube videos into platform-optimized Twitter threads and LinkedIn posts using n8n, Claude API, and social media APIs.

## Structure

- `SKILL.md` - Main skill prompt with workflow architectures, prompt templates, and implementation guides

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
cp -r content-repurposing-engine/ ~/.claude/skills/content-repurposing-engine/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Content Repurposing Engine")
3. Paste into Claude, ChatGPT, Gemini, or your preferred AI assistant
4. Describe your content repurposing needs

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{content_input_type}}` | `youtube_url` | Input source: youtube_url, blog_post_url, podcast_transcript, text_upload |
| `{{target_platforms}}` | `["twitter", "linkedin"]` | Platforms to generate content for |
| `{{llm_model}}` | `claude-3.5-sonnet` | LLM model: claude-3.5-sonnet, claude-3.5-haiku, gpt-4o |
| `{{tone_override}}` | `null` | Force tone: viral, professional, educational, casual, technical |
| `{{max_variations_per_platform}}` | `3` | Number of content variations per platform |
| `{{auto_publish_enabled}}` | `false` | Auto-publish or require human approval |
| `{{temperature_setting}}` | `0.7` | LLM temperature (0.0=deterministic, 1.0=creative) |

## Prerequisites

Before using this skill, ensure you have:

- [ ] Basic understanding of APIs and webhooks
- [ ] Account on n8n (cloud or self-hosted), Zapier, or Make.com
- [ ] Claude API key or OpenAI API key
- [ ] (Optional) Twitter/X Developer account
- [ ] (Optional) LinkedIn Developer account
- [ ] (Optional) Apify account for YouTube transcript extraction

## Quick Start

1. Copy `SKILL.md` content into your AI assistant
2. Describe your situation:
   - What content do you create? (YouTube videos, podcasts, etc.)
   - What platforms do you want to publish to?
   - What's your technical skill level?
   - What's your monthly budget for automation?
3. Get customized workflow architecture and implementation steps
4. Build your workflow in n8n/Zapier/Make.com
5. Test with 1-2 videos before batch processing

## Expected Outputs

When using this skill, you'll receive:

- Custom workflow architecture diagrams
- Platform-specific prompt templates (Twitter, LinkedIn, Instagram)
- API configuration code snippets (Claude, Twitter, LinkedIn)
- Cost estimates and ROI calculations
- Error handling and troubleshooting guidance
- Step-by-step implementation guides

## Cost Estimates

| Tier | Monthly Cost | Best For |
|------|--------------|----------|
| Starter | $25-40 | 1-5 videos/week |
| Growth | $40-70 | 5-15 videos/week |
| Scale | $80-150 | 15-50 videos/week |
| Agency | $200-500 | 50+ videos/week |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
