---
name: creator-revenue-diversifier
version: 1.0.0
---

# Creator Revenue Diversifier

Build multiple income streams beyond ads. Map your revenue stack across digital products, memberships, services, licensing, and passive income — with strategies tailored to your creator size and niche.

## Structure

- `SKILL.md` - Main skill prompt with complete revenue diversification framework, digital product creation guides, community monetization strategies, and financial planning tools

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r creator-revenue-diversifier/ ~/.claude/skills/creator-revenue-diversifier/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Creator Revenue Diversifier")
3. Paste into AI assistant (Claude, ChatGPT, Gemini, Copilot)
4. Share your niche, platform, audience size, current revenue, and income goals
5. Get a personalized revenue diversification plan with specific actions and timelines

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{my_niche_and_platform}}` | `` | Primary niche and platform with audience size |
| `{{my_current_revenue}}` | `` | Current income sources and amounts from creator work |
| `{{my_audience_size}}` | `` | Total audience across platforms and email list size |
| `{{my_skills_and_expertise}}` | `` | Skills beyond content creation (design, coaching, coding, etc.) |
| `{{my_revenue_goal}}` | `` | Monthly or annual income target |

## What's Included

### Revenue Stream Mapping
- All 9 creator revenue streams mapped: ads, sponsorships, digital products, memberships, services, affiliate, licensing, merch, events
- Fit scoring for each stream based on niche, skills, audience size, and capacity
- Revenue Stream Scorecard with priorities and projected monthly income

### Size-Based Income Strategies
- Nano creators (0–1K): services + affiliate focus
- Micro creators (1K–10K): first paid product + email list growth
- Small creators (10K–50K): flagship product + memberships
- Medium creators (50K–200K): product suite + automation
- Large creators (200K+): business building + licensing + premium advisory

### Digital Product Creation Framework
- Product types by niche: knowledge (courses, templates, ebooks), creative (presets, LUTs, assets), lifestyle (programs, plans, guides)
- 4-phase launch framework: validate → create → launch → evergreen
- Pricing ladder from free lead magnets to $997+ accelerator programs
- Platform recommendations (Gumroad, Teachable, Kajabi, Etsy, Skillshare)

### Community Monetization
- Platform comparison: Patreon, YouTube Memberships, Discord, Circle, Skool, Substack, Beehiiv, Whop
- 3-tier membership structure with specific pricing and deliverables
- Retention strategies: onboarding, content cadence, peer connections, value recaps, annual incentives

### Service-Based Income Models
- Stage-appropriate service models from freelancing to premium advisory
- Productized service templates with defined scope and pricing
- Service-to-product pipeline for converting active income to scalable products

### Passive Income Building
- Affiliate marketing: program selection, content strategy, commission optimization
- Licensing: content, stock media, frameworks, white-label opportunities
- Automated sales funnels for evergreen digital products

### Revenue Stack Optimization
- Revenue flywheel showing how streams feed each other
- The 40/30/20/10 diversification rule
- Cross-selling and value ladder strategies
- Revenue efficiency audit framework

### Financial Planning for Creators
- Budget allocation: 30% tax, 25% pay, 20% reinvestment, 15% runway, 10% experiments
- Buffer system for managing irregular income
- Monthly financial dashboard template
- Quarterly revenue review process

### Merchandise and Physical Products
- Print-on-demand platforms: Printful, Spring, Printify, Redbubble
- Digital merch: wallpapers, planners, stickers, icon packs
- When to upgrade from POD to inventory

### Events and Live Experiences
- Event types from paid webinars ($10–97) to retreats ($997–5,000)
- Free-to-paid funnel for virtual events
- Automated replay funnel for evergreen event revenue

## Example Usage

**Prompt:**
"I'm a personal finance creator on YouTube with 120K subscribers and a 15K email list. Right now I make about $3,500/month from AdSense and $2,000/month from one recurring sponsor. I want to hit $15,000/month total. I'm good at explaining complex topics simply and I've been thinking about creating a course, but I don't know where to start or what else I should be doing. Build me a complete revenue diversification plan."

**Expected Output:**
- Revenue Stream Scorecard showing all 9 streams with fit scores and projections
- Digital product strategy: flagship course at $197 (projected $3,000–5,000/month evergreen)
- Membership launch plan: $15/month tier on Patreon or YouTube (projected $1,500–3,000/month at 1–2% conversion)
- Affiliate optimization: finance SaaS tools at 20–40% recurring (projected $500–1,500/month)
- 90-day action plan with weekly milestones
- Financial dashboard template with allocation percentages
- Path to $15,000/month broken down by stream with realistic timelines

---
Downloaded from [Find Skill.ai](https://findskill.ai)