---
name: cta-rotator
version: 1.0.0
---

# CTA Rotator - Initialization

Generate varied, psychology-driven calls to action for YouTube, TikTok, and streaming content. Move beyond repetitive "like and subscribe" requests with contextual CTA variations that maximize engagement.

## What This Skill Does

- Generates 3-5 CTA variations tailored to your content type, audience, and brand voice
- Applies proven psychology frameworks (reciprocity, FOMO, social proof, clarity)
- Recommends optimal CTA placement based on video length
- Matches CTA tone to content genre (tutorial, entertainment, motivational, etc.)
- Provides A/B testing framework for systematic optimization
- Adapts to platform-specific best practices (YouTube, TikTok, Instagram, LinkedIn, Twitch)

## Structure

```
cta-rotator/
├── SKILL.md    - Main skill prompt (500+ lines)
└── INIT.md     - This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r cta-rotator/ ~/.claude/skills/cta-rotator/
```

Then reference in your CLAUDE.md:
```markdown
## Available Skills
| Skill | Location | Use When |
|-------|----------|----------|
| `cta-rotator` | `~/.claude/skills/cta-rotator/` | Generating CTAs for video content |
```

### For ChatGPT/Gemini/Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start requesting CTA variations

## Example Usage

**Basic Request:**
```
Generate 3 CTA variations for my 10-minute Python tutorial. My audience is beginner developers. I want them to subscribe for weekly coding tips.
```

**Detailed Request:**
```
Generate 4 CTA variations for my 12-minute Excel tutorial.
- Audience: business professionals aged 30-55
- Goal: subscribe for weekly productivity tips
- Brand voice: helpful expert (not corporate)
- Psychology: reciprocity (I'm giving value first)
- Placement: one mid-video after technique demo, one at end
```

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{content_genre}}` | `general` | Content type: educational, entertainment, tutorial, motivational, comedic |
| `{{audience_tone}}` | `casual` | How to address audience: casual, professional, formal, playful |
| `{{cta_placement}}` | `mid-end` | Where CTA appears: intro, early_mid, mid, late_mid, end, multi |
| `{{psychological_trigger}}` | `reciprocity` | Persuasion method: fomo, scarcity, reciprocity, social_proof, clarity, urgency |
| `{{creator_brand_voice}}` | `authentic` | Creator style: authentic, energetic, professional, humorous, inspirational |
| `{{platform}}` | `youtube` | Target: youtube, tiktok, instagram, linkedin, twitch, podcast |
| `{{cta_frequency}}` | `2` | Number of CTAs (1-5; recommended 2-3) |
| `{{engagement_goal}}` | `subscribe` | Action: subscribe, like, comment, share, follow, join_community |

## Quick Start Templates

### Tutorial/Educational Content
```
I'm creating a {{video_length}}-minute tutorial about {{topic}}.
My audience is {{audience_description}}.
Generate {{cta_frequency}} CTA variations using reciprocity psychology.
Place one after I demonstrate the main technique and one at the end.
```

### Entertainment/Comedy Content
```
I'm posting a {{video_length}}-minute comedy video about {{topic}}.
My audience is {{age_range}} who watch for entertainment.
My style is {{brand_voice}} (sarcastic/playful/casual).
Generate {{cta_frequency}} CTAs that match my tone - avoid corporate speak.
```

### Professional/B2B Content
```
Creating a {{video_length}}-minute analysis video for {{platform}}.
Audience: {{professional_role}} aged {{age_range}}.
Generate professional, value-focused CTAs.
Use social proof if I can reference subscriber count.
```

## Output Format

The skill generates CTAs in this structure:

```
## CTA Variations for [Content Description]

**Context Summary:**
- Content Type: [type]
- Audience: [description]
- Platform: [platform]
- Brand Voice: [voice]
- Goal: [engagement goal]

---

### Variation 1 (Recommended): [Primary Trigger]
**Placement:** [timing]
**CTA:** "[Full CTA text]"
**Delivery:** [Verbal/Visual/Both] | [Tone notes]

### Variation 2: [Secondary Trigger]
...

### A/B Testing Recommendation:
Test Variation [X] against Variation [Y] over [N] videos.
Track: [metrics]
```

## Psychology Triggers Quick Reference

| Goal | Best Trigger | Example Phrasing |
|------|--------------|------------------|
| Subscribers | Reciprocity | "If this helped, subscribing helps me make more" |
| Urgency | FOMO | "Don't miss next week's deep dive" |
| Trust | Social Proof | "Join 50K professionals who subscribe" |
| Simplicity | Clarity | "Subscribe = weekly tips. That simple." |
| Belonging | Community | "Become part of what we're building" |

## Placement Guidelines

| Video Length | CTA Count | Timing |
|--------------|-----------|--------|
| < 5 min | 1 | End only |
| 5-10 min | 2 | Mid + End |
| 10-20 min | 2-3 | Spaced throughout |
| > 20 min | 2-3 | Every 7-10 min max |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
