---
name: hashtag-freshness-check
version: 1.0.0
---

# Initialization

Hashtag Freshness Check - A diagnostic skill that scans hashtag lists to detect banned, dead, and shadowban-triggering tags on Instagram and TikTok. Provides safe alternatives and optimal mix recommendations for content creators.

## Structure

- `SKILL.md` - Main skill prompt with banned hashtag database, freshness scoring system, audit workflows, and recovery protocols

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r hashtag-freshness-check/ ~/.claude/skills/hashtag-freshness-check/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{platform}}` | `instagram` | Target platform (instagram, tiktok, linkedin, x) |
| `{{strictness_level}}` | `high` | high = flag potential/temporary bans; low = flag only permanently banned |
| `{{target_niche}}` | `general` | Your content niche for relevance analysis |
| `{{max_hashtags}}` | `30` | Maximum hashtags you plan to use |
| `{{min_post_count}}` | `10000` | Minimum volume for a tag to be considered active |

## Capabilities

1. **Banned Tag Detection**: Instantly flags tags known to trigger shadowbans on Instagram and TikTok
2. **"Recent Tab" Verification**: Identifies tags that Instagram has effectively "killed" by removing sorting options
3. **Saturation Analysis**: Categorizes tags as Oversaturated (>10M posts) vs. Niche Sweet Spot (10k-500k)
4. **Freshness Scoring**: Evaluates if a tag is currently trending, active, or stagnant
5. **Alternative Suggestion**: Generates safe, semantically similar replacements for banned tags
6. **Mix Optimization**: Suggests the ideal ratio of broad vs. niche tags
7. **Shadowban Recovery**: Provides step-by-step recovery protocols for accounts experiencing reach drops

## Use Cases

- **Safety Scan**: Check a proposed hashtag list before posting to avoid reach suppression
- **Fresh Tag Discovery**: Generate new, active hashtags for a specific niche
- **Shadowban Diagnosis**: Identify which tags may have caused a sudden reach drop
- **Platform Migration**: Adapt hashtag strategies when moving content between Instagram and TikTok
- **Account Recovery**: Follow a 7-day recovery protocol after shadowban detection

## Example Prompts

**Safety Scan:**
```
Check these hashtags for my home office photo: #desk #workfromhome #productivity #followback #homeoffice #apple #tech #gadgets #workspace #officeinspo
```

**Fresh Suggestions:**
```
I need fresh hashtags for my sourdough bread baking content. My account has 5,000 followers.
```

**Shadowban Recovery:**
```
My Instagram reach dropped 90% yesterday. I used these tags: #valentinesday #dating #single #love. What went wrong and how do I recover?
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
