---
name: influencer-outreach-script
version: 1.0.0
---

# Influencer Outreach Script - Initialization

Generate personalized influencer outreach messages for product gifting, paid partnerships, and affiliate recruitment with FTC-compliant templates.

## What This Skill Does

This skill transforms you into an expert influencer marketing strategist who can:

- Write product seeding/gifting DMs that don't feel transactional
- Craft professional paid partnership pitches via email
- Create affiliate recruitment messages with clear earning potential
- Generate follow-up scripts that aren't pushy
- Draft negotiation responses and counter-offers
- Handle rejections gracefully to maintain relationships

## Structure

```
influencer-outreach-script/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This initialization guide
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r influencer-outreach-script/ ~/.claude/skills/influencer-outreach-script/

# Add to your project's CLAUDE.md
echo "- influencer-outreach-script: ~/.claude/skills/influencer-outreach-script/" >> CLAUDE.md
```

### ChatGPT / Gemini / Copilot Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant at the start of the conversation
4. Provide your outreach context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{influencer_name}}` | `Creator` | The name or handle of the target influencer |
| `{{brand_name}}` | `[My Brand]` | Your company or brand name |
| `{{offer_type}}` | `paid collaboration` | Type: paid collaboration, free gift/seeding, affiliate partnership |
| `{{product_category}}` | `skincare` | The type of product or service being offered |
| `{{specific_compliment}}` | `your recent styling video` | A genuine observation about their content |
| `{{call_to_action}}` | `let me know if you're interested` | The closing ask (soft or hard) |

## Quick Start Examples

### Example 1: Product Gifting DM
```
Write an Instagram DM to @SarahStyles (fashion micro-influencer, 45k followers).
My brand is EcoThreads (sustainable fashion).
I want to offer her our new summer linen dress for free with no strings attached.
Keep it under 50 words, be genuine, and DO NOT ask for a post.
Mention I loved her recent capsule wardrobe video.
```

### Example 2: Paid Partnership Email
```
Draft an outreach email to a tech YouTuber named "Dave" (200k subscribers).
My product is TaskFlow, a productivity app.
I have a $2,000 budget for a 60-second integration.
Include a professional subject line and ask for his media kit.
```

### Example 3: Affiliate Recruitment
```
Write an affiliate pitch to a fitness Instagram creator.
My brand sells protein supplements.
Offer: 20% commission, $80 average order value, 30-day cookie.
Keep it casual but highlight the earning potential.
```

### Example 4: Follow-Up Script
```
Create a polite follow-up email for an influencer who hasn't replied
to my initial offer sent 5 days ago.
The offer was for a paid skincare campaign ($1,500 budget).
Don't be pushy - just ask if they had time to review.
```

## Key Terminology Reference

- **Media Kit**: Influencer's portfolio with demographics, rates, past work
- **Rate Card**: Price list for specific deliverables (Reel, Story, etc.)
- **UGC**: User Generated Content - bought for ads, creator doesn't post
- **Whitelisting**: Brand runs ads through creator's account
- **FTC Disclosure**: Required #ad or #sponsored labels
- **Engagement Rate**: (Likes + Comments) / Followers x 100

## Influencer Tiers

| Tier | Followers | Typical Budget |
|------|-----------|----------------|
| Nano | <10K | Product only |
| Micro | 10K-100K | $200-$2,000 |
| Mid-Tier | 100K-500K | $2,000-$10,000 |
| Macro | 500K-1M | $10,000-$50,000 |
| Mega | 1M+ | $50,000+ |

## Platform Pricing Benchmarks (2024-2025)

| Platform | Content Type | Micro Rate | Macro Rate |
|----------|--------------|------------|------------|
| Instagram | Story | $100-$500 | $500-$2K |
| Instagram | Feed Post | $200-$1K | $1K-$10K |
| Instagram | Reel | $500-$2K | $2K-$20K |
| TikTok | Video | $200-$1K | $1K-$10K |
| YouTube | Integration | $1K-$5K | $5K-$50K |
| YouTube | Dedicated | $2K-$10K | $10K-$100K |

## Best Practices

**DO:**
- Research the creator's recent content before reaching out
- Lead with what THEY get (value-first)
- Keep DMs under 150 words
- Use clear email subject lines
- Follow up once, maximum twice
- Accept "no" gracefully

**DON'T:**
- Offer "exposure" as payment
- Demand posts for gifted products
- Use generic copy-paste templates
- Lowball their published rates
- Send multiple follow-ups
- Ignore their business email in bio

## Troubleshooting

| Problem | Solution |
|---------|----------|
| Getting ignored | More personalization, warm up first, use email |
| Rates too high | Negotiate deliverables, try smaller creators |
| No disclosure | Politely remind, include in contracts |
| Poor performance | Brief may be too restrictive, check audience fit |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
