---
name: membership-tier-designer
version: 1.0.0
---

# Membership Tier Designer - Initialization

Design high-converting membership tiers with strategic pricing, compelling perks, and retention systems for Patreon, Ko-fi, Buy Me a Coffee, Discord, and other creator platforms.

## What This Skill Does

This skill transforms you into a membership monetization strategist capable of:

- **Pricing Psychology Application**: Using anchoring, decoy effect, price sensitivity analysis, and round-number psychology to set tier prices that maximize conversion and average revenue per member
- **Tier Architecture Design**: Building 3-5 tier structures with specific names, pricing, and perk lists tailored to the creator's niche and audience size
- **Platform Selection**: Comparing Patreon, Ko-fi, Buy Me a Coffee, YouTube Memberships, Discord/Whop, Circle, Skool, Substack, and Memberful on fees, features, and creator fit
- **Niche-Specific Perk Design**: Generating sustainable perk ideas for artists, educators, podcasters, writers, gamers, and other creator types
- **Retention System Design**: Building onboarding sequences, monthly engagement cadences, value recap emails, win-back campaigns, and involuntary churn prevention
- **Revenue Projection**: Modeling MRR, ARPM, and growth trajectories with platform fee calculations
- **Launch Planning**: Creating week-by-week launch timelines with founder pricing strategies and migration playbooks

## Package Structure

```
membership-tier-designer/
├── SKILL.md          # Main skill prompt (copy to your AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r membership-tier-designer/ ~/.claude/skills/membership-tier-designer/

# Or for Claude Desktop, add to MCP configuration
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom GPT instructions or conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire prompt content
3. Paste as system instructions or initial context

## Variables

Customize these values when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{creator_type_and_niche}}` | Your creator type and niche | What kind of creator you are and your content focus (e.g., digital artist, fitness YouTuber) |
| `{{current_platform}}` | Patreon | The membership platform you use or plan to use |
| `{{audience_size_and_engagement}}` | Your audience size and engagement level | Total followers/subscribers and engagement metrics |
| `{{current_membership_status}}` | Starting from scratch | Whether you have existing tiers or are launching fresh |
| `{{monthly_revenue_goal}}` | Your target monthly recurring revenue | How much you want to earn per month from memberships |

## Quick Start

After installation, start with one of these prompts:

**Design Membership Tiers from Scratch**
```
I'm a [creator type] on [platform] with [X] followers. I want to launch memberships on [Patreon/Ko-fi/etc.] with a goal of $[X]/month in recurring revenue. My audience is [description of audience]. Design a complete tier structure with pricing, perks, and a launch plan.
```

**Optimize Existing Tiers**
```
I have a Patreon with [X] members across [N] tiers. Here's my current setup: [paste tier names, prices, perks, member counts]. My ARPM is $[X] and my monthly churn is [X]%. Help me redesign my tiers to increase revenue and reduce churn.
```

**Compare Membership Platforms**
```
I'm a [creator type] with [X] followers and I'm choosing between [Platform A] and [Platform B] for memberships. I expect [X] members at around $[X]/month average. Help me choose the right platform based on fees, features, and my creator type.
```

**Launch Plan for New Membership**
```
I've designed my tiers and I'm ready to launch. My audience is [X] across [platforms], my email list is [X], and I'm launching on [platform]. Build me a week-by-week launch plan including pre-launch, launch week, and the first 30 days after launch.
```

**Retention Audit**
```
My membership has [X] members but I'm losing [X]% per month. Here's my current setup: [tiers, perks, content cadence, community activity]. Help me diagnose the churn causes and build a retention system to reduce it.
```

## Key Workflows

1. **Full Tier Design from Scratch** - Pricing psychology analysis, tier architecture, niche-specific perks, platform selection, revenue projection, launch timeline
2. **Tier Optimization** - ARPM analysis, decoy placement, perk sustainability audit, upgrade path design
3. **Platform Comparison and Migration** - Fee impact modeling, feature comparison, migration playbook with member retention strategies
4. **Launch Campaign Design** - Pre-launch seeding, waitlist building, founder pricing, launch week sequence, post-launch nurture
5. **Retention System Build** - Onboarding sequence, monthly cadence calendar, value recap templates, win-back campaigns, dunning email optimization

## Expected Outputs

- Complete tier structure with names, pricing, perk lists, and member distribution targets
- Platform comparison with fee impact calculations showing net revenue
- Revenue projection with conversion benchmarks, ARPM analysis, and 3/6/12-month growth models
- Launch timeline (week-by-week) with founder pricing strategy
- Retention system including onboarding sequence, monthly cadence, value recap template, and win-back flows
- Perk sustainability audit flagging burnout risks
- 90-day post-launch review plan with metrics to track

## Related Skills

- **Creator Revenue Diversifier** - Map your full revenue stack beyond memberships
- **Audience Persona Builder** - Understand who your members are so you design perks they value
- **Newsletter Growth Engine** - Build the email list that drives membership signups
- **Brand Deal Negotiator** - Negotiate sponsorships that complement (not cannibalize) membership perks
- **Social Media Bio Writer** - Craft bios that funnel followers toward your membership

---

Downloaded from [Find Skill.ai](https://findskill.ai)
