---
name: personal-brand-builder
version: 1.0.0
---

# Personal Brand Builder - Initialization

Develop unique positioning, content pillars, and multi-platform content strategy to build a distinctive professional brand that attracts ideal opportunities.

## What This Skill Does

This skill transforms you into an expert personal branding strategist capable of:

- **Brand Discovery**: Uncovering authentic positioning through strengths, values, and market analysis
- **Positioning Development**: Crafting clear, memorable personal brand statements and elevator pitches
- **Content Pillar Creation**: Establishing 3-5 strategic content themes aligned with expertise
- **Platform Optimization**: Tailoring LinkedIn, GitHub, websites, and social profiles for maximum impact
- **Content Strategy**: Building 90-day content calendars with sustainable production workflows
- **Brand Systems**: Developing visual identity, voice guidelines, and consistency frameworks

## Package Structure

```
personal-brand-builder/
├── SKILL.md          # Main skill prompt (copy to your AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r personal-brand-builder/ ~/.claude/skills/personal-brand-builder/

# Or for Claude Desktop, add to MCP configuration
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom GPT instructions or conversation

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the entire prompt content
3. Paste as system instructions or initial context

## Variables

Customize these values when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{brand_niche}}` | Your specific area of expertise | The narrow domain where you position authority (e.g., "conversion UX design", "lean startup methodology") |
| `{{target_audience_segment}}` | Decision-makers in your industry | Your primary audience (e.g., "early-stage founders", "mid-career engineers") |
| `{{content_pillar_count}}` | 3 | Number of core content themes (recommended 3-5) |
| `{{posting_frequency}}` | 3-5 posts per week on LinkedIn | Publishing cadence per platform |
| `{{brand_personality}}` | Authentic, approachable, expert | Adjectives describing desired perception |

## Quick Start

After installation, start with one of these prompts:

**Complete Brand Building**
```
I want to build my personal brand from scratch. I'm a [role] with [X years] experience in [domain]. My goal is to [attract clients/get speaking gigs/build industry recognition]. Guide me through the complete brand building process.
```

**Content Strategy Only**
```
I already know my positioning: I help [audience] achieve [outcome] through [approach]. Now I need to develop 3-4 content pillars and a 90-day content calendar for LinkedIn. Help me create this strategy.
```

**Platform Optimization**
```
I need to optimize my LinkedIn profile and personal website to better reflect my brand as [positioning]. Audit my current presence and give me a specific action plan.
```

## Key Workflows

1. **Brand Discovery & Foundation Building** - Self-assessment, market analysis, UVP development, brand statement creation
2. **Content Strategy & Pillar Development** - Topic brainstorming, pillar selection, messaging frameworks, voice/tone guidelines
3. **Multi-Platform Optimization** - Profile audits, visual identity, LinkedIn optimization, cross-platform consistency
4. **90-Day Content Calendar Creation** - Monthly themes, weekly planning, production schedule, engagement activities
5. **Brand Monitoring & Iteration** - Guidelines documentation, analytics setup, quality assurance, continuous improvement

## Expected Outputs

- Personal brand statement (120-150 words)
- Elevator pitch variations (10s, 30s, 2min)
- 3-5 documented content pillars with subtopics
- Messaging matrix and voice guidelines
- 90-day content calendar
- Platform optimization checklists
- Brand guidelines document

## Related Skills

- **Personal Brand Clarity Session** - For foundational self-discovery before strategy
- **LinkedIn Profile Optimizer** - For deep LinkedIn optimization
- **Content Pillar Mapper** - For advanced content theme development
- **Social Media Content Calendar** - For detailed calendar planning

---

Downloaded from [Find Skill.ai](https://findskill.ai)
