---
name: cross-cultural-communicator
version: 1.0.0
description: Adapt communication for any culture using Erin Meyer's Culture Map and Hofstede's dimensions
author: FindSkill.ai
license: MIT
---

# Initialization

A cross-cultural communication advisor that helps you adapt emails, meetings, negotiations, feedback, and everyday conversations for different cultural contexts. Built on Erin Meyer's Culture Map (8 dimensions), Hofstede's Cultural Dimensions (6 dimensions), and Edward T. Hall's high-context/low-context theory. Includes detailed regional profiles for 20+ countries covering North America, Western Europe, East Asia, South Asia, Southeast Asia, Middle East, Africa, and Latin America.

## What Makes This Different

| Generic Advice | Cross-Cultural Communicator |
|----------------|----------------------------|
| "Be respectful" | Maps specific cultural dimensions between your culture and theirs |
| "Adapt your style" | Shows exactly HOW to adapt with before/after examples |
| Tips for one culture | Covers 20+ countries with validated research frameworks |
| Surface-level etiquette | Deep cultural logic explaining WHY norms exist |

## Structure

This is a prompt-only skill:

```
cross-cultural-communicator/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r cross-cultural-communicator/ ~/.claude/skills/cross-cultural-communicator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `my_culture` | (empty) | My own cultural background or communication style |
| `my_target_culture` | (empty) | My target audience's cultural background (e.g., Japanese, German, Brazilian) |
| `my_communication_type` | email | My type of communication (email, presentation, negotiation, casual chat) |
| `my_context` | (empty) | My specific situation or context |

## Key Features

### 1. Culture Map Comparison
Maps both your culture and the target culture on Erin Meyer's 8 dimensions (Communicating, Evaluating, Persuading, Leading, Deciding, Trusting, Disagreeing, Scheduling) and identifies the biggest gaps to focus on.

### 2. Email and Message Adaptation
Takes your draft message and rewrites it for the recipient's cultural context, with annotations explaining every change and the cultural reasoning behind it.

### 3. Meeting and Presentation Prep
Provides a detailed preparation checklist for cross-cultural meetings covering protocol, seating, introductions, small talk, agenda structure, discussion style, and follow-up expectations.

### 4. Feedback Delivery
Adapts how you deliver positive or negative feedback based on the recipient's cultural expectations for directness, privacy, and framing.

### 5. Negotiation Strategy
Maps cultural negotiation preferences (competitive, collaborative, relationship-first, contract-first) and provides tactical advice for cross-cultural deal-making.

### 6. Gift-Giving and Social Protocol
Covers gift-giving taboos and expectations, dining etiquette, hospitality norms, and social behavior for major business cultures.

### 7. Time Perception Guide
Explains monochronic vs. polychronic time orientation with practical adaptation strategies for scheduling across cultures.

## Regional Coverage

- **North America**: US, Canada
- **Western Europe**: Germany, France, UK, Netherlands, Spain, Italy, Sweden
- **East Asia**: Japan, China, South Korea
- **South Asia**: India
- **Southeast Asia**: Singapore, Philippines, Thailand, Indonesia, Vietnam, Malaysia
- **Middle East**: Saudi Arabia, UAE, Qatar
- **Africa**: Nigeria, Kenya, South Africa, Ghana
- **Latin America**: Brazil, Mexico

## Best Used For

- Writing emails to international colleagues or clients
- Preparing for meetings with people from different cultures
- Giving feedback across cultural boundaries
- International business negotiations
- Leading multicultural remote teams
- Avoiding cross-cultural communication blunders
- Building trust with global partners
- Understanding why miscommunications keep happening

## Example Interaction

**User**: I'm an American manager and I need to give performance feedback to my Japanese team member who missed a deadline. How should I approach this?

**Skill Response**:
1. Maps US vs. Japan on the Culture Map (huge gaps on Communicating, Evaluating, Leading)
2. Explains that direct feedback in a meeting would cause loss of face
3. Recommends a private one-on-one setting
4. Provides a culturally adapted feedback script using indirect language
5. Explains why "that would be difficult" means "no" in Japanese culture
6. Suggests focusing on the system/process rather than the individual

---
Downloaded from [Find Skill.ai](https://findskill.ai)
