---
name: analytics-so-what
version: 1.0.0
---

# Initialization

Transform raw metrics into actionable business insights using the "So What?" methodology. This skill helps data analysts, marketers, and business professionals bridge the gap between data collection and decision-making by systematically answering "So What?" and "Now What?" for every metric.

## Structure

- `SKILL.md` - Main skill prompt with complete methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r analytics-so-what/ ~/.claude/skills/analytics-so-what/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{metric_threshold_concern}}` | `20%` | Percentage change that triggers investigation |
| `{{segmentation_depth}}` | `3` | How many levels deep to segment data |
| `{{context_lookback_window}}` | `30 days` | Historical context to examine when analyzing changes |
| `{{audience_technical_level}}` | `moderate` | Communication style: 'technical', 'moderate', or 'executive' |
| `{{confidence_threshold}}` | `95%` | Statistical significance required before claiming findings |
| `{{action_urgency_level}}` | `medium` | Recommendation priority: 'critical', 'medium', or 'low' |

## Example Usage

**E-Commerce Analysis:**
```
Our checkout abandonment rate jumped from 18% to 26% yesterday. Walk me through what might be causing this and what I should check first. Assume I have access to technical logs, user session recordings, and my conversion funnel data.
```

**Marketing Performance:**
```
My paid search campaign's CTR is 2.1%, CPC is $4.20, and conversion rate is 3.5%. My boss asked, "So what? Are we doing well?" I need to explain whether these numbers are good and what I should do about them.
```

**Product Analytics:**
```
Session duration on our onboarding flow is 4 minutes, and 35% of users bounce at step 3. Our completion rate is 78%. Is this good? Should we optimize, and where should we focus?
```

## Key Capabilities

1. **Metric Interpretation** - Converting raw numerical data into human-readable business meaning
2. **Root Cause Analysis** - Understanding why a metric changed or what drives specific patterns
3. **Actionable Insight Generation** - Transforming observations into specific, executable recommendations
4. **Data Storytelling** - Crafting narratives around data to communicate findings compellingly
5. **Business Impact Translation** - Connecting metrics to revenue, cost savings, efficiency, or satisfaction
6. **Segmentation & Pattern Recognition** - Identifying which data subsets matter and hidden patterns
7. **Decision Enablement** - Providing clear "what should we do next?" guidance

## Workflows Included

1. **High Bounce Rate Root Cause Analysis** - Systematic investigation of why users are leaving
2. **KPI to Strategy Translation** - Converting dashboard metrics into strategic recommendations
3. **Dashboard Pattern Mining** - Finding hidden insights in metric dashboards
4. **Stakeholder Narrative Development** - Translating findings into executive-level communication
5. **Segmentation Deep Dive** - Uncovering stories hidden in aggregate metrics

## Best Practices

- Always start with the business question before analyzing
- Use segmentation to uncover truth hidden in blended metrics
- Combine quantitative data with qualitative user feedback
- Connect every metric to business outcomes (revenue, cost, efficiency, satisfaction)
- Communicate insights as narratives, not spreadsheets
- Never present findings without recommendations

---
Downloaded from [Find Skill.ai](https://findskill.ai)
