---
name: budget-variance-analyzer
version: 2.0.0
---

# Initialization

Compare actual spending vs. budgeted amounts with month-over-month and year-over-year analysis, root cause investigation using the Five Whys technique, and actionable recommendations for financial improvement.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive variance analysis framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r budget-variance-analyzer/ ~/.claude/skills/budget-variance-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{materiality_threshold_percent}}` | `10` | Percentage threshold (0-100%) above which variances are flagged for investigation |
| `{{materiality_threshold_dollars}}` | `1000` | Dollar amount threshold above which variances are flagged (variances must exceed BOTH thresholds) |
| `{{comparison_period_type}}` | `monthly` | Period comparison type for analysis (monthly, quarterly, annual) |
| `{{variance_calculation_method}}` | `actual_minus_budget` | Calculation method for variances |
| `{{include_prior_year_comparison}}` | `true` | Include YoY variance alongside MoM/QoQ for trend context |
| `{{variance_classification_scheme}}` | `favorable_unfavorable` | Labeling scheme for variances |

## Key Features

- **Seven Core Capabilities**: MoM analysis, YoY comparison, BvA reporting, root cause investigation, variance classification, percentage calculation, trend analysis
- **Five Whys Technique**: Structured root cause investigation methodology
- **15 Essential Concepts**: Comprehensive terminology including materiality thresholds, flexible budgets, rolling forecasts
- **5 Analysis Workflows**: Monthly reports, root cause investigation, YoY comparison, rolling forecast adjustment, quarterly review
- **10 Best Practices**: From materiality thresholds to cross-functional collaboration
- **5 Troubleshooting Scenarios**: Common variance issues and resolutions

---
Downloaded from [Find Skill.ai](https://findskill.ai)
