---
name: cash-flow-projection-generator
version: 1.0.0
---

# Initialization

Cash Flow Projection Generator helps SMB business owners, finance managers, and CFOs forecast monthly cash position, identify shortfall risks before they become crises, and optimize working capital through DSO/DPO management.

## Structure

```
cash-flow-projection-generator/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r cash-flow-projection-generator/ ~/.claude/skills/cash-flow-projection-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are a cash flow projection specialist...")
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{projection_period}}` | `12 months` | Number of months to forecast (3, 6, or 12) |
| `{{minimum_buffer}}` | `$50,000` | Target minimum cash balance to maintain |
| `{{dso_days}}` | `45 days` | Days Sales Outstanding - average collection period |
| `{{dpo_days}}` | `30 days` | Days Payable Outstanding - average payment period |
| `{{fixed_monthly_expenses}}` | `$50,000` | Total fixed operating costs per month |
| `{{growth_rate}}` | `5%` | Expected monthly revenue growth rate |

## Key Concepts

- **DSO (Days Sales Outstanding)**: Average days to collect customer payments
- **DPO (Days Payable Outstanding)**: Average days to pay suppliers
- **CCC (Cash Conversion Cycle)**: DIO + DSO - DPO
- **Working Capital**: Current assets minus current liabilities
- **Minimum Buffer**: 1-3 months of fixed operating costs (more for seasonal businesses)

## Workflows Included

1. **Building a Monthly Forecast** - First-time 12-month projection setup
2. **Monthly Forecast Update** - 15-30 minute monthly refresh process
3. **Shortfall Analysis & Mitigation** - Identify gaps and solutions
4. **Seasonal Forecasting** - Handle revenue/expense variations
5. **Scenario Planning** - Base, upside, downside, and stress test modeling

## Quick Start Example

```
"I run a B2B software company with $100K monthly revenue growing 10%/month.
My fixed costs are $80K/month (salaries + infrastructure).
Customers typically take 60 days to pay invoices.
Current cash is $150K.

Build me a 12-month forecast showing:
1. When will I face a cash shortfall at current growth?
2. What's my minimum cash point and when?
3. What credit line should I secure now as insurance?"
```

## Related Skills

- **Financial Projections** - 3-5 year projections for startups
- **Financial Ratio Analyzer** - Liquidity and profitability ratios
- **Cost-Benefit Analysis** - NPV, ROI, IRR calculations
- **Cost Structure Analyzer** - Fixed vs. variable cost breakdown
- **Cash Flow Projector** - Personal/simpler cash flow tracking

---

Downloaded from [Find Skill.ai](https://findskill.ai)
