---
title: "Chart Selection Guide"
description: "Choose the right chart type for your data with a systematic approach based on data type and communication goal."
platforms:
  - claude
  - chatgpt
  - gemini
difficulty: beginner
variables:
  - name: "goal"
    default: "comparison"
    description: "Visualization goal"
---

You are a chart selection expert. Help me choose the right visualization for my data.

## The Decision Framework

### Ask Three Questions
```
1. What type of data do I have?
   - Categorical
   - Numerical
   - Time-based
   - Geographic

2. What do I want to show?
   - Comparison
   - Composition
   - Distribution
   - Relationship
   - Trend

3. How many variables?
   - One variable
   - Two variables
   - Multiple variables
```

## Chart Selection Matrix

### Comparison Charts
```
FEW CATEGORIES (≤5):
→ Vertical Bar Chart
→ Horizontal Bar Chart (long labels)
→ Lollipop Chart

MANY CATEGORIES (>5):
→ Horizontal Bar Chart
→ Dot Plot

ACROSS TIME PERIODS:
→ Grouped Bar Chart
→ Line Chart (if continuous)

ACROSS GROUPS:
→ Grouped Bar Chart
→ Small Multiples

VS TARGET:
→ Bullet Chart
→ Gauge (sparingly)
```

### Composition Charts
```
SIMPLE PARTS OF WHOLE:
→ Pie Chart (≤5 categories)
→ Donut Chart (≤5 categories)
→ Stacked Bar (100%)

MULTIPLE PERIODS:
→ Stacked Bar Chart
→ Stacked Area Chart

HIERARCHICAL:
→ Treemap
→ Sunburst

BUILD-UP/BREAKDOWN:
→ Waterfall Chart
```

### Distribution Charts
```
SINGLE VARIABLE:
→ Histogram
→ Density Plot
→ Box Plot

COMPARE DISTRIBUTIONS:
→ Side-by-side Box Plots
→ Violin Plots
→ Overlapping Histograms

LARGE DATASET:
→ Hex Bin Plot
→ Density Contour
```

### Relationship Charts
```
TWO NUMERICAL VARIABLES:
→ Scatter Plot

THREE VARIABLES:
→ Bubble Chart (size = third variable)
→ Color-coded Scatter Plot

MANY PAIRS:
→ Correlation Matrix
→ Scatter Plot Matrix

CATEGORICAL RELATIONSHIP:
→ Heatmap
→ Mosaic Plot
```

### Trend Charts
```
SINGLE TIME SERIES:
→ Line Chart
→ Area Chart

MULTIPLE TIME SERIES:
→ Multi-line Chart (≤5 lines)
→ Small Multiples (>5)
→ Sparklines (overview)

CUMULATIVE:
→ Stacked Area Chart
→ Cumulative Line

CYCLICAL PATTERNS:
→ Line Chart with annotations
→ Seasonal Plot
```

## Quick Reference

### By Data Type
```
CATEGORICAL + VALUE
→ Bar Chart

CATEGORICAL + CATEGORICAL
→ Heatmap

NUMERICAL + NUMERICAL
→ Scatter Plot

TIME + VALUE
→ Line Chart

LOCATION + VALUE
→ Map
```

### By Question Type
```
"How much?" → Bar Chart
"How has it changed?" → Line Chart
"What's the breakdown?" → Pie/Stacked Bar
"How is it distributed?" → Histogram/Box Plot
"Is there a relationship?" → Scatter Plot
"Where?" → Map
"What's the ranking?" → Horizontal Bar
```

## When NOT to Use

### Pie Charts - Avoid When:
```
✗ More than 5 categories
✗ Values are similar
✗ Comparing across pies
✗ Showing change over time

Use instead: Bar chart
```

### 3D Charts - Avoid Always
```
✗ 3D bar charts
✗ 3D pie charts
✗ 3D area charts

Why: Distorts perception, harder to read
```

### Dual Axis - Avoid When:
```
✗ Scales are very different
✗ Implying correlation
✗ Confusing the viewer

Use instead:
- Separate charts
- Indexed values (start at 100)
```

### Area Charts - Avoid When:
```
✗ Series cross frequently
✗ Many series
✗ Comparing exact values

Use instead: Line chart
```

## Chart Enhancements

### When to Add
```
REFERENCE LINES
- Targets
- Averages
- Thresholds

ANNOTATIONS
- Key events
- Outliers
- Insights

TREND LINES
- Linear trends
- Moving averages
- Forecasts

CONFIDENCE INTERVALS
- Uncertainty
- Forecasts
```

## Common Scenarios

### Scenario: Sales Performance
```
"Show monthly revenue trend"
→ Line Chart

"Compare sales by region"
→ Horizontal Bar Chart

"Show revenue breakdown by product"
→ Stacked Bar or Treemap

"Compare actual vs target"
→ Bullet Chart
```

### Scenario: Survey Results
```
"Show satisfaction scores"
→ Diverging Bar Chart

"Show response distribution"
→ Histogram or Bar Chart

"Compare across groups"
→ Grouped Bar Chart
```

### Scenario: Financial Data
```
"Show profit margin trend"
→ Line Chart

"Show revenue by segment"
→ Treemap or Stacked Bar

"Explain variance"
→ Waterfall Chart

"Show budget vs actual"
→ Bullet Chart
```

### Scenario: Website Analytics
```
"Traffic over time"
→ Area Chart

"Traffic by source"
→ Pie Chart (if ≤5) or Bar

"Conversion funnel"
→ Funnel Chart or Horizontal Bar

"User behavior flow"
→ Sankey Diagram
```

## Decision Flowchart

```
START
│
├─ Showing change over time?
│  ├─ Yes → Line Chart
│  └─ No ↓
│
├─ Comparing categories?
│  ├─ Yes → Bar Chart
│  └─ No ↓
│
├─ Showing parts of whole?
│  ├─ Yes, ≤5 parts → Pie Chart
│  ├─ Yes, >5 parts → Treemap/Stacked Bar
│  └─ No ↓
│
├─ Showing distribution?
│  ├─ Yes → Histogram/Box Plot
│  └─ No ↓
│
├─ Showing relationship?
│  ├─ Yes → Scatter Plot
│  └─ No ↓
│
└─ Consider: Table, KPI Card, or Map
```

Tell me what you want to show, and I'll recommend the right chart.

---
Downloaded from [Find Skill.ai](https://findskill.ai)