---
name: competitive-intelligence-analyzer
version: 1.0.0
---

# Competitive Intelligence Analyzer - Initialization

Transform into a predictive competitive intelligence powerhouse. This skill enables you to predict competitor moves 12-24 months in advance using patent filings, GitHub activity, trademark records, and Reddit community intelligence.

## What This Skill Does

- **Patent Intelligence**: Analyze USPTO, EPO, and WIPO filings to predict product roadmaps
- **GitHub Monitoring**: Interpret repository activity to reveal development priorities
- **Trademark Analysis**: Monitor filings to predict brand strategies and geographic expansion
- **Reddit Intelligence**: Extract authentic customer sentiment from 100,000+ subreddit communities
- **Win/Loss Integration**: Connect competitive intelligence to sales outcomes
- **Predictive Synthesis**: Generate probability-scored predictions with supporting evidence

## Structure

```
competitive-intelligence-analyzer/
├── SKILL.md       # Main skill prompt (copy to your AI assistant)
└── INIT.md        # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r competitive-intelligence-analyzer/ ~/.claude/skills/competitive-intelligence-analyzer/
```

Then reference in your Claude Code sessions when you need competitive intelligence analysis.

### For ChatGPT / Gemini / Copilot Users

1. Open `SKILL.md` in this folder
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Begin your competitive intelligence analysis session

### Quick Start Prompts

After loading the skill, try these example prompts:

**Market Disruption Response:**
```
Our competitor just announced a 41% price reduction on their premium tier.
Is this desperation or strategy? Check their recent patents, GitHub activity,
hiring signals, and Reddit sentiment. Should we match, differentiate, or wait?
```

**Predictive Product Intelligence:**
```
What will our three biggest competitors likely launch in the next 18 months?
Search patents, GitHub, trademarks, hiring patterns, and job postings.
Give me probability-scored predictions with supporting evidence.
```

**Reddit-Driven Customer Insights:**
```
Find unmet customer needs, competitor complaints, and feature requests in
r/startups, r/SaaS, r/entrepreneur, r/ProductManagement over the last 3 months.
Show exact Reddit quotes from high-upvote posts.
```

**Weekly Intelligence Brief:**
```
Generate a weekly competitive intelligence brief for [Company Name] covering:
- Top 5 competitor moves this week
- Patent filing alerts
- Reddit sentiment shifts
- Recommended responses
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{competitor_list}}` | `Competitor A, Competitor B, Competitor C` | Companies to monitor (direct and indirect) |
| `{{monitoring_scope}}` | `patents, github, trademarks, reddit, pricing` | Categories of competitor activities to track |
| `{{data_sources}}` | `patents, github, trademark, reddit, news` | Intelligence sources to aggregate |
| `{{prediction_horizon}}` | `12 months` | Time window for predictive intelligence |
| `{{industry}}` | `SaaS / Technology` | Your industry or market segment |
| `{{intelligence_priority}}` | `product roadmap, pricing changes, market expansion` | Primary Key Intelligence Questions |

## Key Frameworks Included

### CI Maturity Model
- Level 1: Ad-hoc research
- Level 2: Planned process
- Level 3: Systematic monitoring
- Level 4: Integrated organization
- Level 5: Strategic predictive

### Signal Triangulation
- Single source = 30-50% confidence
- Two sources = 50-70% confidence
- Three+ sources = 70-90% confidence

### Timeline Estimation
- Patent → Product: 18-24 months
- Trademark → Launch: 6-18 months
- GitHub spike → Release: 3-6 months
- Hiring surge → Capability: 6-12 months

## Output Formats Available

1. **Executive Summary Brief** - High-level findings and recommendations
2. **Competitive Battlecard** - Sales-ready one-pager
3. **Prediction Report** - Probability-scored forecasts with evidence
4. **Weekly Intelligence Brief** - Ongoing monitoring summary
5. **Win/Loss Analysis** - Sales outcome correlation

## Who This Is For

- Product & Marketing Teams
- Sales Leaders & Teams
- Business Development Professionals
- Startup Founders
- Strategic Planners
- C-Suite Executives
- Investment Professionals

## Related Skills

- AI Spy: Competitive Intelligence System (real-time monitoring)
- Competitive Analysis Framework (SWOT/Porter's)
- Competitor Review Spy (review mining)
- Sentiment Analysis (text analysis)
- Product-Market Fit Radar (PMF measurement)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
