---
name: cost-benefit-analysis
version: 1.0.0
---

# Cost-Benefit Analysis Skill Initialization

Transform investment decisions into rigorous, defensible financial analyses with NPV, ROI, IRR calculations, sensitivity testing, and intangible benefit valuation.

## Overview

This skill enables AI assistants to conduct professional-grade cost-benefit analyses for:
- Build vs. buy software decisions
- Hire vs. outsource evaluations
- Capital investment justifications
- Policy and program evaluations
- Strategic initiative prioritization

## Structure

```
cost-benefit-analysis/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r cost-benefit-analysis/ ~/.claude/skills/cost-benefit-analysis/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# Cost-Benefit Analysis Expert")
3. Paste into ChatGPT as a system prompt or create a Custom GPT

### Gemini
1. Open `SKILL.md`
2. Copy the skill content
3. Use as a prompt prefix or in Google AI Studio

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into your preferred AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{time_horizon_years}}` | `5` | Number of years for the analysis projection |
| `{{discount_rate}}` | `0.07` | Annual discount rate (7%) for present value calculations |
| `{{currency}}` | `USD` | Currency for all monetary values |
| `{{include_intangibles}}` | `true` | Whether to monetize soft benefits (morale, brand) |
| `{{sensitivity_range}}` | `0.20` | Percentage variation (+/- 20%) for sensitivity analysis |
| `{{tax_rate}}` | `0.0` | Corporate tax rate for post-tax ROI (0% default) |

## Key Capabilities

### Financial Metrics
- **NPV (Net Present Value)**: Sum of discounted cash flows minus initial investment
- **ROI (Return on Investment)**: Percentage return relative to costs
- **IRR (Internal Rate of Return)**: Discount rate that makes NPV = 0
- **BCR (Benefit-Cost Ratio)**: PV of benefits divided by PV of costs
- **Payback Period**: Time to recover initial investment

### Analysis Types
- Go/No-Go investment decisions
- Multi-option comparisons
- Sensitivity and breakeven analysis
- Scenario planning (optimistic/likely/pessimistic)

### Cost Categories
- Direct costs (CapEx, OpEx)
- Indirect costs (training, productivity loss)
- Hidden costs (technical debt, vendor lock-in)
- Risk-adjusted costs (contingency, overrun buffers)

### Benefit Quantification
- Revenue-based benefits
- Cost savings benefits
- Productivity gains
- Risk mitigation value
- Intangible benefit proxies

## Example Usage

```
We're deciding whether to build a custom inventory management system
($200k development, $30k/year maintenance) or use NetSuite ($45k/year
subscription). Our current manual process costs us $80k/year in labor.
Use a 5-year horizon with 8% discount rate. Calculate NPV and ROI for
both options and recommend the best path.
```

## Best Practices

1. **Always include the null option** - Compare against "do nothing"
2. **Document all assumptions** - Every number needs a source or logic
3. **Be conservative** - Overestimate costs, underestimate benefits
4. **Use consistent discount rates** - Don't manipulate for desired outcomes
5. **Include sensitivity analysis** - Show how changes affect the decision

## Reference Sources

This skill incorporates methodology from:
- OMB Circular A-94 (US Government CBA Guidelines)
- HM Treasury Green Book (UK Appraisal Guidance)
- Academic research on reference class forecasting
- Industry best practices from Galorath and Tempo

---
Downloaded from [Find Skill.ai](https://findskill.ai)
