---
name: cost-structure-analyzer
version: 1.0.0
---

# Cost Structure Analyzer - Initialization

Break down fixed vs. variable costs, calculate break-even points, implement activity-based costing (ABC), and identify cost optimization opportunities for maximum profitability.

## Structure

```
cost-structure-analyzer/
├── SKILL.md    # Main skill prompt with full analysis workflows
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r cost-structure-analyzer/ ~/.claude/skills/cost-structure-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Start with: "Analyze my business cost structure"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{fixed_costs_monthly}}` | `50000` | Total monthly fixed costs (rent, salaries, insurance, subscriptions) |
| `{{variable_cost_per_unit}}` | `12.50` | Direct cost to produce/deliver one unit |
| `{{selling_price_per_unit}}` | `35.00` | Revenue per unit sold |
| `{{monthly_sales_volume}}` | `5000` | Expected units sold per month |
| `{{cost_allocation_method}}` | `variable_costing` | Method for overhead allocation: variable_costing or absorption_costing |
| `{{semi_variable_cost_percentage}}` | `15` | Percentage of total costs that are semi-variable (mixed) |

## Capabilities

This skill provides:

1. **Cost Classification & Separation** - Categorize expenses into fixed, variable, and semi-variable components with statistical methods
2. **Break-Even Analysis** - Calculate sales volume and revenue needed to achieve profitability at different price points
3. **Contribution Margin Calculation** - Determine how much each sale contributes to covering fixed costs and generating profit
4. **Cost Driver Identification** - Pinpoint what activities/factors cause costs to increase
5. **Activity-Based Costing (ABC)** - Allocate overhead costs to products/services based on actual resource consumption
6. **Cost Structure Optimization** - Identify conversion opportunities (fixed→variable), elimination targets, and efficiency improvements
7. **Scenario & Sensitivity Analysis** - Model impacts of volume changes, price adjustments, or cost reductions on profitability

## Example Usage

**SaaS Company Break-Even:**
```
I run a SaaS company charging $500/month per customer. Monthly fixed costs are $150,000 (salaries, cloud infrastructure, support team). Variable costs run about $50 per customer (payment processing, customer support hours). We currently have 450 customers. What's our break-even point and how much profit are we making? Should we raise prices to $600?
```

**Manufacturing Cost Optimization:**
```
We manufacture small appliances. Annual revenue is $12M with 100,000 units sold. COGS is 55% of revenue. Annual fixed costs total $3M (plant overhead, management salaries, facility). We're getting pressure to cut costs by 10%. Where should we focus?
```

**Service Business Profitability:**
```
We run a digital marketing agency with three service lines: SEO ($5K/month contracts, 25 clients), PPC ($8K/month, 15 clients), Content ($3K/month, 40 clients). Fixed costs are $80K/month. Variable costs run 30% of revenue for SEO, 25% for PPC, 40% for Content. Which service line is most profitable?
```

## Key Formulas

```
Contribution Margin = Price - Variable Cost per Unit
CM Ratio = CM ÷ Price
Break-Even Units = Fixed Costs ÷ CM per Unit
Break-Even Revenue = Fixed Costs ÷ CM Ratio
Profit = (Price × Volume) - (VC × Volume) - Fixed Costs
Margin of Safety = Current Volume - Break-Even Volume
Operating Leverage = CM ÷ Operating Income
```

## Related Skills

- **Financial Analytics** - Analyze financial data and build models
- **Financial Ratio Analyzer** - Calculate profitability and efficiency ratios
- **Budget Variance Analyzer** - Compare actual vs. budgeted spending
- **Cash Flow Projector** - Project future cash flows
- **Pricing Strategy Analyzer** - Develop optimal pricing strategies
- **Financial Projections** - Create 3-5 year financial projections

---
Downloaded from [Find Skill.ai](https://findskill.ai)
