---
name: csv-data-cleaner
version: 1.0.0
description: Clean messy CSV and spreadsheet data — fix missing values, remove duplicates, standardize formats, validate data
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive data cleaning expertise covering all common data quality issues, multi-tool cleaning scripts (Python pandas, Google Sheets, SQL), and a systematic 3-phase cleaning process (Assessment → Cleaning → Validation).

**Time to initialize**: ~3 minutes

## Directory Structure

```
csv-data-cleaner/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with any AI assistant and your preferred data tool (Python, Google Sheets, SQL, Excel).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Describe your messy data (columns, types, sample rows)
2. List the problems you've noticed (duplicates, missing values, inconsistent formats)
3. Choose your tool (Python pandas, Google Sheets, SQL, Excel)
4. Get a complete cleaning script with explanations

### Key Principles

- Always profile data before cleaning (know what you're dealing with)
- Fix structural issues first, then content issues
- Remove exact duplicates before fuzzy matching
- Standardize text (trim, case, categories) before validation
- Document every cleaning step for auditability
- Save both cleaned data and a cleaning log

## Compatibility

Tested with: All AI assistants + Python pandas, Google Sheets, SQL, Excel

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{data_description}}` | `CSV export from CRM with customer records` | What the data looks like |
| `{{problems}}` | `duplicate rows, inconsistent date formats, missing emails` | Data quality issues |
| `{{tool_preference}}` | `Python pandas` | Cleaning tool to use |
| `{{output_needed}}` | `deduplicated, consistent dates, standardized phones` | Desired clean output |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
