---
name: customer-product-profitability-analyzer
version: 1.0.0
---

# Customer & Product Profitability Analyzer - Initialization

This skill enables AI assistants to perform comprehensive profitability analysis by customer and product using Activity-Based Costing (ABC), Time-Driven ABC (TDABC), and cost-to-serve methodologies.

## What This Skill Does

- Analyzes true profitability by customer segment and product line
- Allocates indirect costs using proven methodologies (ABC, TDABC, pro-rata)
- Segments customers into A/B/C categories based on profitability (Pareto analysis)
- Calculates cost-to-serve ratios and identifies expensive-to-serve customers
- Provides multi-dimensional profitability analysis (customer × product × region)
- Generates actionable recommendations for pricing, retention, and portfolio optimization

## Package Structure

```
customer-product-profitability-analyzer/
├── SKILL.md    # Main skill prompt with all capabilities
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill. The AI uses the SKILL.md instructions to perform profitability analysis on user-provided data.

## Post-Init Steps

### For Claude Code

```bash
# Copy to Claude Code skills directory
cp -r customer-product-profitability-analyzer/ ~/.claude/skills/customer-product-profitability-analyzer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial context
4. Begin your profitability analysis session

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `cost_allocation_method` | `pro_rata` | How to allocate indirect costs: `pro_rata`, `activity_based`, `equal`, or `custom` |
| `include_indirect_costs` | `true` | Whether to include overhead, support, and delivery costs in analysis |
| `margin_threshold_profitable` | `0` | Minimum profit margin (%) to classify as profitable |
| `segment_by_dimension` | `customer` | Primary analysis dimension: `customer`, `product`, `segment`, `region`, or `combination` |
| `profitability_period` | `annual` | Time period for analysis: `monthly`, `quarterly`, `annual`, or `lifetime` |
| `abc_segmentation_a_percent` | `0.20` | Top percentage for A segment (Pareto analysis) |

## Example Usage

Start a session with a prompt like:

```
I'm the CFO of a B2B distribution company with 150 customers. I suspect some
customers are unprofitable after accounting for delivery, support, and returns
costs. Can you help me:

1. Set up a customer profitability analysis
2. Segment customers into A/B/C categories
3. Identify which customers are truly unprofitable and why
4. Recommend actions for each segment
```

## Key Capabilities

1. **ABC Customer Profitability Analysis** - Segment customers by true profitability
2. **Product-Line Margin Analysis** - Calculate margins by product with full cost allocation
3. **Cost-to-Serve Analysis** - Identify expensive-to-serve customers and optimization opportunities
4. **Multi-Dimensional Analysis** - Cross-tabulate profitability by customer × product × region
5. **Unprofitable Customer Turnaround** - Diagnose issues and model improvement scenarios

## Data Requirements

To perform profitability analysis, users should have:

**Minimum Data:**
- Revenue by customer or product
- Direct costs (COGS)

**Ideal Data:**
- Revenue by customer AND product
- COGS by customer/product
- Indirect cost totals (overhead, support, delivery)
- Activity data (orders, shipments, support tickets, returns)

## Output Formats

The skill generates:
- Customer profitability tables with A/B/C segmentation
- Product margin analysis with contribution ranking
- Cost-to-serve breakdowns by activity
- Multi-dimensional profitability matrices
- Actionable recommendations with quantified impact

---

Downloaded from [Find Skill.ai](https://findskill.ai)
