---
name: customer-segmentation
version: 1.0.0
---

# Customer Segmentation - Initialization Guide

Transform your customer base into actionable segments using RFM analysis, K-Means clustering, and behavioral data. Identify high-value customers, predict churn, and build targeted acquisition strategies.

## Package Contents

```
customer-segmentation/
├── SKILL.md    # Main skill prompt (copy this to your AI assistant)
└── INIT.md     # This initialization file
```

## Quick Start

### Claude Code Installation

```bash
# Copy to Claude Code skills directory
cp -r customer-segmentation/ ~/.claude/skills/customer-segmentation/
```

Then reference in conversations:
```
Use the customer-segmentation skill to analyze my customer data
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation with your AI assistant
4. Or save as a custom GPT/Gem for reuse

## What This Skill Does

### Core Capabilities

1. **RFM Analysis**
   - Calculate Recency, Frequency, Monetary scores
   - Create segments: Champions, Loyal, At-Risk, Lost
   - Develop segment-specific strategies

2. **K-Means Clustering**
   - Guide feature selection and data preparation
   - Determine optimal cluster count (Elbow Method)
   - Interpret clusters and create personas

3. **Acquisition Strategy**
   - Build lookalike audiences from high-value segments
   - Calculate CAC/LTV projections by segment
   - Design channel and messaging strategies

4. **Churn Risk Segmentation**
   - Score customers by churn probability
   - Segment by risk level
   - Design intervention playbooks

5. **Real-Time Dynamic Segmentation**
   - Define behavior-triggered segment rules
   - Connect to marketing automation
   - Monitor segment migration patterns

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `recency_window_days` | `365` | Days to look back for recency calculation. Use 90 for fast-moving retail, 730 for B2B |
| `num_clusters` | `5` | Number of K-Means clusters. Determine via Elbow Method, typically 3-8 |
| `high_value_percentile` | `75` | Percentile threshold for "high value" classification |
| `churn_definition_days` | `180` | Days of inactivity = churned. 30 for SaaS, 365 for annual subscription |
| `frequency_threshold` | `5` | Minimum purchases to classify as "frequent buyer" |
| `cac_payback_months` | `12` | Target CAC payback period for acquisition planning |

## Example Usage

**Basic RFM Analysis:**
```
Analyze our e-commerce transaction data for the past 12 months.
We have customer_id, order_date, and order_amount fields.
Create RFM segments and recommend strategies for each.
```

**K-Means Clustering:**
```
I have a customer dataset with these features:
- Total purchases, total spend, average order value
- Days since last purchase, email open rate
- Product categories purchased

Help me cluster these customers and create marketing personas.
```

**Acquisition Strategy:**
```
Based on our existing customer segments, develop acquisition
strategies for targeting lookalike audiences. Our highest-value
segment has average LTV of $1,200 and 20% profit margin.
```

**Churn Prevention:**
```
Build a churn risk scoring system for our SaaS product.
We track: login frequency, feature usage, support tickets,
plan tier, and billing history. Segment by risk level.
```

## Data Requirements

For best results, prepare:

**Transaction Data (minimum):**
- `customer_id` - Unique customer identifier
- `order_date` - Transaction timestamp
- `order_amount` - Purchase value

**Enhanced Analysis (optional):**
- Engagement metrics (sessions, email opens, app usage)
- Demographic data (age, location, income)
- Behavioral data (cart abandons, returns, categories)

## Output Examples

The skill produces structured outputs including:

- **Segment Profiles**: Size, characteristics, strategies
- **Acquisition Playbooks**: Personas, messaging, channels, CAC targets
- **Churn Dashboards**: Risk distribution, indicators, intervention ROI
- **Cluster Interpretations**: Feature means, personas, marketing tactics

## Integration Notes

### Data Platforms
- Works with exports from Shopify, Stripe, HubSpot, Salesforce
- Compatible with CSV, Excel, or SQL query results
- Can guide Python/SQL implementation if needed

### Marketing Tools
- Outputs compatible with Klaviyo, Mailchimp, HubSpot segments
- Lookalike audience specs for Meta, Google, LinkedIn
- Workflow triggers for Zapier, Make, or native automation

## Related Skills

- **Customer Analytics** - Broader behavior analysis and LTV calculations
- **Cohort Analysis** - Track user behavior over time by acquisition date
- **A/B Testing** - Validate segment strategies with statistical rigor
- **Customer Retention Strategy Builder** - Detailed retention playbooks

## Troubleshooting

**Segments too similar?**
- Add more differentiating features
- Try different clustering algorithms
- Reduce number of clusters

**One segment dominates?**
- Apply log transformation to reduce outlier impact
- Increase cluster count
- Create sub-segments

**Can't develop distinct strategies?**
- Add psychographic research (surveys)
- Merge similar segments
- Focus on fewer, more distinct groups

---
Downloaded from [Find Skill.ai](https://findskill.ai)
