---
name: expense-category-auditor
version: 1.0.0
---

# Expense Category Auditor - Initialization

An AI-driven financial control system that automatically identifies miscategorized expenses, duplicate submissions, policy violations, and fraud patterns using ML anomaly detection techniques. Achieves 90-95% fraud detection accuracy while reducing false positives through contextual behavioral analysis.

## Package Structure

```
expense-category-auditor/
├── SKILL.md       # Main skill prompt with full capabilities
└── INIT.md        # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r expense-category-auditor/ ~/.claude/skills/expense-category-auditor/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or as conversation context
4. Begin by providing expense data for analysis

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{anomaly_sensitivity_threshold}}` | `0.75` | Detection aggressiveness (0-1). Higher catches more issues but increases false positives. |
| `{{duplicate_match_tolerance}}` | `0.85` | Similarity threshold for duplicate detection (0-1). |
| `{{policy_enforcement_mode}}` | `soft_alert` | Violation handling: soft_alert (warning), hard_stop (block), escalate (route). |
| `{{contextual_analysis_enabled}}` | `true` | Enable behavioral baseline comparison for contextual anomalies. |
| `{{approval_escalation_threshold_usd}}` | `5000` | Dollar amount triggering higher approval authority. |
| `{{receipt_verification_required}}` | `true` | Require receipt image analysis for expenses above threshold. |
| `{{quarterly_consistency_audit_enabled}}` | `true` | Enable automatic quarterly GL coding pattern audits. |

## Quick Start

### Minimum Required Input
```
Analyze this expense data for categorization consistency and policy violations:

[Paste CSV with columns: Date, Amount, Vendor, Category, Submitter, Department]
```

### Full Analysis Request
```
I have 6 months of expense data from our ERP. Our policies:
- Meals: $75/person limit
- Entertainment: Requires director approval over $200
- All expenses >$25 require receipts
- VP approval needed for anything over $5,000

Analyze for:
1. Categorization inconsistencies
2. Duplicate submissions
3. Policy violations
4. Fraud risk indicators

[Attach expense export]
```

## Core Workflows

1. **Real-Time Submission Auditing** - Catch fraud at submission before processing
2. **Quarterly Consistency Audit** - Detect systematic categorization errors before external audits
3. **Fraud Investigation Deep Dive** - Comprehensive evidence gathering for suspected fraud
4. **Pre-Audit Preparation** - 60-day readiness assessment before scheduled audits
5. **Post-Merger Standardization** - Consolidate expense systems after M&A

## Key Capabilities

- **Categorization Consistency**: Flag vendors coded to multiple GL accounts
- **Multi-Method Anomaly Detection**: Statistical (Z-score), ML (Isolation Forest), Deep Learning (autoencoders)
- **Duplicate Detection**: Fuzzy matching for repeated submissions
- **Policy Validation**: Real-time checking against spending limits and approval rules
- **Receipt Verification**: Image quality and manipulation detection
- **Contextual Analysis**: Role/department-aware anomaly scoring
- **Predictive Patterns**: Forecast-based deviation detection

## Supported Integrations

- QuickBooks Online
- Xero
- NetSuite
- SAP Concur
- Generic CSV exports

## Success Metrics

| Metric | Target |
|--------|--------|
| Audit exception rate | <5% |
| Categorization consistency | >92% |
| Duplicate detection rate | >90% |
| False positive rate | <2% |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
