---
name: financial-model-builder
version: 1.0.0
description: Build professional financial models — 3-statement models, DCF valuations, SaaS metrics, LBO analysis, revenue forecasts, sensitivity analysis
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive financial modeling expertise covering 3-statement models, DCF valuations, SaaS metrics dashboards, LBO analysis, revenue build-up models, sensitivity analysis, and industry-specific templates. Professional-grade formulas with cell reference logic for Excel and Google Sheets.

**Time to initialize**: ~3 minutes

## Directory Structure

```
financial-model-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with any AI assistant, Excel, and Google Sheets.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Describe your business type and industry
2. State what the model is for (fundraising, planning, valuation)
3. Share current financials and key metrics
4. Specify assumptions to model
5. Get a complete model with formulas, tab structure, and explanations

### Key Principles

- Keep all inputs in a dedicated Assumptions tab (blue font)
- Never hardcode numbers in formulas — always reference cells
- Add balance check rows to catch BS imbalances
- Use consistent time periods throughout
- Build sensitivity tables on every key output
- Color-code: blue = input, black = formula, green = cross-sheet link

## Compatibility

Tested with: All AI assistants + Excel, Google Sheets

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_type}}` | `B2B SaaS startup` | Business type or industry |
| `{{model_purpose}}` | `Series A fundraising` | What the model is for |
| `{{revenue_details}}` | `$50K MRR, 3 pricing tiers` | Current revenue and pricing |
| `{{key_assumptions}}` | `20% growth, 5% churn, $500 CAC` | Assumptions to model |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
