---
name: goodwill-impairment-tester
version: 1.0.0
---

# Initialization

Expert guidance for ASC 350/IAS 36 goodwill impairment testing, including DCF valuation, triggering event analysis, and audit-ready documentation for CFOs, controllers, and financial analysts.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive impairment testing workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r goodwill-impairment-tester/ ~/.claude/skills/goodwill-impairment-tester/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{forecast_period_years}}` | `5` | Number of years for explicit DCF cash flow projections |
| `{{perpetual_growth_rate}}` | `2.5%` | Long-term steady-state growth rate for terminal value |
| `{{discount_rate_wacc}}` | `8.0%` | Weighted average cost of capital for discounting |
| `{{ebitda_margin_assumption}}` | `Historical 3-year average` | Operating margin basis for projections |
| `{{market_comparable_multiple}}` | `Peer group EV/EBITDA median` | Valuation multiple for market approach |
| `{{accounting_standard}}` | `US GAAP (ASC 350)` | Regulatory framework (US GAAP or IFRS) |

## Quick Start Examples

### Annual Impairment Test
```
We acquired TechCorp for $180M with $45M goodwill 3 years ago.
It's year-end and I need to perform our annual goodwill impairment test.
Revenue is $120M with 25% EBITDA margins. Walk me through the process.
```

### Triggering Event Assessment
```
Our largest customer (30% of revenue) just terminated their contract.
Do we need to perform interim impairment testing? Our carrying amount
is $180M with $45M allocated goodwill.
```

### DCF Model Build
```
Help me build a DCF valuation model for our SaaS reporting unit.
I need 5-year projections with terminal value using 9% WACC and
2.5% perpetual growth rate.
```

### Audit Preparation
```
I need to prepare audit workpapers for our goodwill impairment testing.
Help me create a testing memorandum and disclosure checklist that meets
ASC 350 requirements.
```

## Key Capabilities

1. **Reporting Unit Identification** - Determine appropriate testing level (ASC 280 segments or components)
2. **Qualitative Assessment** - Evaluate whether quantitative testing is required
3. **DCF Valuation** - Build comprehensive discounted cash flow models
4. **WACC Calculation** - Determine appropriate discount rates using CAPM
5. **Impairment Calculation** - Compare fair value to carrying amount and calculate losses
6. **Triggering Event Analysis** - Identify events requiring interim testing
7. **Audit Documentation** - Prepare audit-ready workpapers and disclosures

## Regulatory References

**US GAAP:**
- ASC 350-20: Goodwill - Subsequent Measurement
- ASC 820: Fair Value Measurement
- ASU 2017-04: Simplifying the Test for Goodwill Impairment

**IFRS:**
- IAS 36: Impairment of Assets
- IFRS 3: Business Combinations
- IFRS 13: Fair Value Measurement

---
Downloaded from [Find Skill.ai](https://findskill.ai)
