---
name: google-sheets-ai-assistant
version: 1.0.0
description: Master Google Sheets with formulas, QUERY, Gemini AI functions, and Apps Script automation
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive Google Sheets expertise covering all built-in functions, Google Sheets exclusive functions (QUERY, ARRAYFORMULA, IMPORTRANGE, SPARKLINE), Gemini AI functions (=AI(), =Gemini()), Apps Script automation, common task templates, and troubleshooting.

**Time to initialize**: ~3 minutes

## Directory Structure

```
google-sheets-ai-assistant/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with any AI assistant and Google Sheets.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Describe your task and data structure
2. Get the exact formula or Apps Script code
3. Copy formula directly into Google Sheets
4. For Apps Script: Extensions → Apps Script → paste code

### Key Principles

- Use QUERY for complex data analysis (SQL-like syntax in Sheets)
- Use ARRAYFORMULA instead of copying formulas down rows
- Wrap lookups in IFERROR for clean error handling
- Use =AI() for intelligent data processing with Gemini
- Apps Script for automation beyond what formulas can do

## Compatibility

Tested with: All AI assistants + Google Sheets (web, mobile, API)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{task_description}}` | `calculate monthly sales totals by region` | What to do |
| `{{data_description}}` | `columns: Date, Region, Product, Quantity, Unit Price` | Data structure |
| `{{skill_level}}` | `intermediate` | Experience level |
| `{{automation_needed}}` | `formulas only` | Whether Apps Script needed |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
