---
name: involuntary-churn-recovery
version: 1.0.0
---

# Involuntary Churn Recovery - Initialization

Recover failed payments and reduce involuntary churn with smart retry strategies, dunning email sequences, card update campaigns, and pre-dunning prevention systems.

## What This Skill Does

This skill transforms you into an expert in subscription billing recovery, helping you:

- **Analyze payment failures** by failure code and recoverability potential
- **Design smart retry strategies** optimized by failure type, timing, and customer value
- **Create dunning email sequences** that recover 65-80% of failed payments
- **Implement pre-dunning prevention** for expiring cards
- **Build recovery dashboards** with essential metrics and alerting
- **Segment dunning approaches** by customer value and tenure

## Structure

```
involuntary-churn-recovery/
├── SKILL.md      # Main skill prompt (copy to AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r involuntary-churn-recovery/ ~/.claude/skills/involuntary-churn-recovery/
```

Then reference in your CLAUDE.md:

```markdown
## Available Skills

| Skill | Location | Use When |
|-------|----------|----------|
| `involuntary-churn-recovery` | `~/.claude/skills/involuntary-churn-recovery/` | Failed payments, dunning, payment recovery |
```

### ChatGPT / Claude.ai / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start asking about payment recovery, dunning, or failed payments

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{payment_processor}}` | `stripe` | Payment processor: stripe, braintree, chargebee, recurly, paddle |
| `{{retry_strategy}}` | `smart` | Retry approach: smart (ML), fixed (scheduled), exponential (backoff) |
| `{{dunning_sequence_length}}` | `4` | Number of dunning emails (3-7 typical) |
| `{{grace_period_days}}` | `7` | Days before hard churn after retries fail (3-14 range) |
| `{{pre_dunning_window}}` | `14` | Days before card expiration to trigger pre-dunning |
| `{{escalation_threshold}}` | `3` | Failed attempts before human escalation |

## Example Usage

**Optimize existing dunning:**
```
Our SaaS has 2,000 subscribers on Stripe. Last month, 8% of payments
failed and we recovered only 40% automatically. Analyze our current
dunning setup and design an optimized recovery system including:
1. Smart retry timing based on failure codes
2. A 5-email dunning sequence with specific subject lines and copy
3. Pre-dunning flow for expiring cards
4. Metrics dashboard to track recovery rate by failure reason

Target: 75% recovery rate within 14 days.
```

**Create dunning emails:**
```
Write a 4-email dunning sequence for a B2B SaaS product ($99/month).
Include subject lines, email body copy, and optimal send timing.
Tone should be helpful, not aggressive.
```

**Analyze failure patterns:**
```
Here's our payment failure data from last month:
- insufficient_funds: 45%
- expired_card: 30%
- card_declined: 15%
- other: 10%

What's our maximum recovery potential and what should we prioritize?
```

## Key Capabilities

1. **Failure Code Analysis**: Classify failures by recovery potential (high/medium/low)
2. **Smart Retry Timing**: Optimize retry schedules by failure type, time of day, and day of month
3. **Dunning Sequences**: Create 4-6 email sequences with proven copy frameworks
4. **Pre-Dunning Prevention**: Proactive card expiration campaigns
5. **Segment-Based Dunning**: Different approaches for high-value, long-tenure, and new customers
6. **Multi-Channel Recovery**: Email, SMS, in-app, and phone strategies
7. **Metrics & Dashboards**: Track recovery rate, time to recovery, and segment performance

## Target Benchmarks

| Metric | Basic | Optimized | With This Skill |
|--------|-------|-----------|-----------------|
| Recovery Rate | 30-40% | 50-65% | 65-80% |
| Time to Recovery | 14+ days | 10 days | < 7 days |
| Dunning Open Rate | 20% | 35% | > 40% |

## Related Skills

- **SaaS Churn Analyzer**: Predict voluntary churn and build health scores
- **Customer Retention Strategy Builder**: Design systematic retention plans
- **Customer Win-Back Campaigns**: Re-engage customers who have churned

---

Downloaded from [Find Skill.ai](https://findskill.ai)
