---
name: margin-compression-debugger
version: 1.0.0
---

# Margin Compression Debugger - Initialization

An expert financial analyst skill for diagnosing why profit margins are shrinking. Combines systematic root cause analysis, cost component breakdown, product mix evaluation, and data-driven fix recommendations.

## What This Skill Does

- **Root Cause Diagnosis**: Determines if margin decline stems from pricing pressure, cost inflation, product mix shifts, operational inefficiency, or external market factors
- **Cost Component Analysis**: Breaks down COGS and operating expenses to identify which specific cost drivers are compressing margins
- **Trend & Pattern Recognition**: Identifies inflection points, seasonality, and momentum in margin changes
- **Product/Customer Mix Analysis**: Detects revenue shifts toward lower-margin offerings and quantifies impact
- **Benchmarking**: Compares margins against industry standards and internal targets
- **Scenario Modeling**: Runs sensitivity analyses on pricing, costs, and volume
- **Actionable Recommendations**: Provides prioritized interventions with expected ROI

## Package Structure

```
margin-compression-debugger/
├── SKILL.md    # Main skill prompt (copy this to your AI assistant)
└── INIT.md     # This initialization guide
```

## Files to Generate

None required. This is a prompt-only skill - all instructions are contained in `SKILL.md`.

## Installation

### Claude Code
```bash
# Copy to Claude skills directory
cp -r margin-compression-debugger/ ~/.claude/skills/margin-compression-debugger/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (`---` section)
3. Paste into Custom GPT instructions or conversation context

### Gemini / Copilot / Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter
3. Paste as a system prompt or prepend to your conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{analysis_period}}` | `last_12_months` | Time period for margin trend analysis. Options: `last_quarter`, `last_12_months`, `last_3_years`, custom range |
| `{{alert_threshold}}` | `2%` | Percentage deviation from target margin that triggers investigation alert |
| `{{cost_segments}}` | `cogs, labor, overhead, sga` | Cost categories to analyze. Customize based on your cost structure |
| `{{benchmarking_type}}` | `industry_average` | Comparison set: `industry_average`, `peer_companies`, `prior_year`, `internal_target` |
| `{{scenario_variables}}` | `material_cost, labor_rate, price, volume` | Factors to stress-test in scenario modeling |
| `{{product_segmentation}}` | `product_line` | Margin analysis level: `product_line`, `customer_segment`, `geography`, `sales_channel` |

## Quick Start

After installation, try these prompts:

### Emergency Investigation
```
Our gross margin dropped from 45% to 40% in the past 6 months. Here's our P&L:
[Paste your P&L data]

Identify the top 3 drivers of this margin decline and quantify each.
```

### Dashboard Setup
```
We're a [industry] company with these product tiers: [list tiers].
What margin KPIs should we track monthly? What alert thresholds make sense?
```

### Cost Reduction Planning
```
We need to improve net margin from 12% to 15%. Here's our cost structure:
[Paste cost breakdown]

Identify cost reduction opportunities and model their margin impact.
```

### Pricing Analysis
```
We're facing competitive pricing pressure. Current margins by tier:
- Premium: 55%
- Standard: 35%
- Budget: 15%

Model the impact of a 5% price increase on Premium tier.
```

## Best Results Tips

1. **Provide P&L data** - At least 6-12 months of revenue, COGS, and expense breakdown
2. **Include segmentation** - Product, customer, or geographic breakdowns enable mix analysis
3. **Specify industry** - Enables relevant benchmarking comparisons
4. **Share context** - Known external factors, competitive changes, or operational issues help with root cause diagnosis

## Key Outputs You'll Get

- **Variance waterfall charts** - Visual breakdown of margin drivers
- **Root cause ranking** - Top 3-5 drivers ranked by impact magnitude
- **Cost reduction opportunity matrix** - Prioritized by impact/effort
- **Scenario models** - What-if analyses on key variables
- **Implementation roadmaps** - Phased action plans with timeline

## Related Skills

- [Cost Structure Analyzer](/skills/data-analytics/cost-structure-analyzer/) - Fixed/variable cost breakdown
- [Budget Variance Analyzer](/skills/data-analytics/budget-variance-analyzer/) - Root cause analysis for budget variances
- [Pricing Strategy Analyzer](/skills/productivity/pricing-strategy-analyzer/) - Pricing optimization
- [Financial Projections Generator](/skills/productivity/financial-projections/) - Revenue and expense forecasting

---

Downloaded from [Find Skill.ai](https://findskill.ai)
