---
name: pricing-power-analyzer
version: 1.0.0
---

# Pricing Power Analyzer - Initialization

Measure your company's ability to raise prices without losing customers. This skill enables comprehensive pricing power analysis including elasticity measurement, willingness-to-pay research, customer segmentation by price sensitivity, and scenario modeling before implementation.

## What This Skill Does

- Calculates price elasticity of demand from historical data
- Conducts willingness-to-pay research (Van Westendorp, Gabor-Granger methods)
- Segments customers by price sensitivity
- Models price increase scenarios with revenue and churn projections
- Designs A/B pricing experiments for validation
- Provides structured outputs: scorecards, scenario tables, sensitivity matrices

## Structure

```
pricing-power-analyzer/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
# Copy skill to Claude Code skills directory
cp -r pricing-power-analyzer/ ~/.claude/skills/pricing-power-analyzer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `base_price` | `99.00` | Current product price in customer's currency |
| `price_increase_percent` | `10` | Percentage increase to model (5-20% typical) |
| `elasticity_coefficient` | `-0.8` | Price elasticity of demand (-0.1 to -2.0+) |
| `current_customer_count` | `1000` | Number of active customers in segment |
| `current_monthly_churn_rate` | `0.05` | Baseline monthly churn rate as decimal |
| `cltv_months` | `24` | Customer lifetime value calculation window |

## Quick Start Examples

### Baseline Assessment
```
Analyze our pricing power: We charge $299/month for our SaaS platform,
have 5,000 customers with 3% monthly churn. NPS is 52. Our main
competitor charges $349/month. What's our pricing power position?
```

### Scenario Planning
```
Model a 10% price increase scenario. Current state: $50,000/year
enterprise license, 200 customers, 8% annual churn, $300,000 CLV.
Historical elasticity is -0.6. What's the revenue impact?
```

### Willingness-to-Pay Research
```
Design a Van Westendorp study for our new product. Target customers
are mid-market SaaS buyers. Competitors charge $75-$125/month.
Our cost is $15/user/month.
```

### Segment Analysis
```
Segment our customer base by price sensitivity. We have:
- 500 enterprise accounts ($5k+/month, 2% churn)
- 2000 SMB accounts ($200/month, 5% churn)
- 3000 startup accounts ($50/month, 8% churn)
Which segments can handle price increases?
```

## Key Concepts

- **Price Elasticity of Demand (PED)**: % change in quantity / % change in price
- **Inelastic Demand**: PED > -1.0 (strong pricing power)
- **Elastic Demand**: PED < -1.0 (weak pricing power)
- **Net Revenue Retention**: Revenue retained after churn + expansion
- **Van Westendorp**: Survey method finding optimal price range
- **Gabor-Granger**: Sequential method measuring demand curve

## Elasticity Interpretation

| PED Range | Classification | Pricing Power |
|-----------|---------------|---------------|
| -0.5 to 0 | Highly inelastic | Very strong |
| -1.0 to -0.5 | Inelastic | Strong |
| -1.5 to -1.0 | Elastic | Moderate |
| < -1.5 | Highly elastic | Weak |

## Related Skills

- **Pricing Strategy Optimizer** - Dynamic pricing optimization after measuring power
- **Customer Analytics** - Customer segmentation and LTV analysis
- **SaaS Churn Analyzer** - Predict churn impact from price changes
- **A/B Testing** - Design statistically rigorous pricing experiments
- **Competitive Analysis** - Benchmark pricing against competitors

---

Downloaded from [Find Skill.ai](https://findskill.ai)
